/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.DownsamplingIterator;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.Iterator;
import java.util.Random;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Randomly down-sample a SAM or BAM file to retain a random subset of the reads. Mate-pairs are either both kept or both discarded. Reads marked as not primary alignments are all discarded. Each read is given a probability P of being retained - results with the exact same input in the same order and with the same value for RANDOM_SEED will produce the same results.", usageShort="Down-sample a SAM or BAM file to retain a random subset of the reads", programGroup=SamOrBam.class)
public class DownsampleSam
extends CommandLineProgram {
    @Option(shortName="I", doc="The input SAM or BAM file to downsample.")
    public File INPUT;
    @Option(shortName="O", doc="The output, downsampled, SAM or BAM file to write.")
    public File OUTPUT;
    @Option(shortName="R", doc="Random seed to use if reproducibilty is desired.  Setting to null will cause multiple invocations to produce different results.")
    public Long RANDOM_SEED = 1L;
    @Option(shortName="P", doc="The probability of keeping any individual read, between 0 and 1.")
    public double PROBABILITY = 1.0;
    private final Log log = Log.getInstance(DownsampleSam.class);

    public static void main(String[] args) {
        new DownsampleSam().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        Random r = this.RANDOM_SEED == null ? new Random() : new Random(this.RANDOM_SEED);
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(in.getFileHeader(), true, this.OUTPUT);
        ProgressLogger progress = new ProgressLogger(this.log, 10000000, "Wrote");
        DownsamplingIterator iterator = new DownsamplingIterator((Iterator)in.iterator(), r, this.PROBABILITY);
        for (SAMRecord rec : iterator) {
            out.addAlignment(rec);
            progress.record(rec);
        }
        out.close();
        CloserUtil.close((Object)in);
        this.log.info(new Object[]{"Finished! Kept " + iterator.getKeptReads() + " out of " + iterator.getTotalReads() + " reads."});
        return 0;
    }
}

