/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ListMap;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.artifacts.ContextAccumulator;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.analysis.artifacts.Transition;

class ArtifactCounter {
    private final String sampleAlias;
    private final String library;
    private final Set<String> fullContexts;
    private final Map<String, String> leadingContextMap;
    private final Map<String, String> trailingContextMap;
    private final Map<String, String> zeroContextMap;
    private final ContextAccumulator fullContextAccumulator;
    private final ContextAccumulator halfContextAccumulator;
    private final ContextAccumulator zeroContextAccumulator;
    private final List<SequencingArtifactMetrics.PreAdapterSummaryMetrics> preAdapterSummaryMetricsList;
    private final List<SequencingArtifactMetrics.PreAdapterDetailMetrics> preAdapterDetailMetricsList;
    private final List<SequencingArtifactMetrics.BaitBiasSummaryMetrics> baitBiasSummaryMetricsList;
    private final List<SequencingArtifactMetrics.BaitBiasDetailMetrics> baitBiasDetailMetricsList;

    public ArtifactCounter(String sampleAlias, String library, int contextSize, boolean expectedTandemReads) {
        this.sampleAlias = sampleAlias;
        this.library = library;
        this.fullContexts = new HashSet<String>();
        for (byte[] kmer : SequenceUtil.generateAllKmers((int)(2 * contextSize + 1))) {
            this.fullContexts.add(StringUtil.bytesToString((byte[])kmer));
        }
        String padding = StringUtil.repeatCharNTimes((char)'N', (int)contextSize);
        this.leadingContextMap = new HashMap<String, String>();
        this.trailingContextMap = new HashMap<String, String>();
        this.zeroContextMap = new HashMap<String, String>();
        for (String context : this.fullContexts) {
            String leading = context.substring(0, contextSize);
            String trailing = context.substring(contextSize + 1, context.length());
            char center = context.charAt(contextSize);
            this.leadingContextMap.put(context, leading + center + padding);
            this.trailingContextMap.put(context, padding + center + trailing);
            this.zeroContextMap.put(context, padding + center + padding);
        }
        HashSet<String> halfContexts = new HashSet<String>();
        halfContexts.addAll(this.leadingContextMap.values());
        halfContexts.addAll(this.trailingContextMap.values());
        HashSet<String> zeroContexts = new HashSet<String>();
        zeroContexts.addAll(this.zeroContextMap.values());
        this.fullContextAccumulator = new ContextAccumulator(this.fullContexts, expectedTandemReads);
        this.halfContextAccumulator = new ContextAccumulator(halfContexts, expectedTandemReads);
        this.zeroContextAccumulator = new ContextAccumulator(zeroContexts, expectedTandemReads);
        this.preAdapterSummaryMetricsList = new ArrayList<SequencingArtifactMetrics.PreAdapterSummaryMetrics>();
        this.preAdapterDetailMetricsList = new ArrayList<SequencingArtifactMetrics.PreAdapterDetailMetrics>();
        this.baitBiasSummaryMetricsList = new ArrayList<SequencingArtifactMetrics.BaitBiasSummaryMetrics>();
        this.baitBiasDetailMetricsList = new ArrayList<SequencingArtifactMetrics.BaitBiasDetailMetrics>();
    }

    public void countRecord(String refContext, char calledBase, SAMRecord rec) {
        if (this.fullContexts.contains(refContext)) {
            this.fullContextAccumulator.countRecord(refContext, calledBase, rec);
            this.halfContextAccumulator.countRecord(this.leadingContextMap.get(refContext), calledBase, rec);
            this.halfContextAccumulator.countRecord(this.trailingContextMap.get(refContext), calledBase, rec);
            this.zeroContextAccumulator.countRecord(this.zeroContextMap.get(refContext), calledBase, rec);
        }
    }

    public void finish() {
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> allDetailMetrics = this.getDetailMetrics();
        Map<Transition, SequencingArtifactMetrics.SummaryPair> allSummaryMetrics = this.getSummaryMetrics();
        for (Transition transition : Transition.altValues()) {
            SequencingArtifactMetrics.SummaryPair summary = allSummaryMetrics.get((Object)transition);
            List details = (List)allDetailMetrics.get((Object)transition);
            this.preAdapterSummaryMetricsList.add(summary.preAdapterMetrics);
            this.baitBiasSummaryMetricsList.add(summary.baitBiasMetrics);
            for (SequencingArtifactMetrics.DetailPair detail : details) {
                this.preAdapterDetailMetricsList.add(detail.preAdapterMetrics);
                this.baitBiasDetailMetricsList.add(detail.baitBiasMetrics);
            }
        }
    }

    public List<SequencingArtifactMetrics.PreAdapterSummaryMetrics> getPreAdapterSummaryMetrics() {
        return this.preAdapterSummaryMetricsList;
    }

    public List<SequencingArtifactMetrics.PreAdapterDetailMetrics> getPreAdapterDetailMetrics() {
        return this.preAdapterDetailMetricsList;
    }

    public List<SequencingArtifactMetrics.BaitBiasSummaryMetrics> getBaitBiasSummaryMetrics() {
        return this.baitBiasSummaryMetricsList;
    }

    public List<SequencingArtifactMetrics.BaitBiasDetailMetrics> getBaitBiasDetailMetrics() {
        return this.baitBiasDetailMetricsList;
    }

    private Map<Transition, SequencingArtifactMetrics.SummaryPair> getSummaryMetrics() {
        HashMap<Transition, SequencingArtifactMetrics.SummaryPair> summaryMetricsMap = new HashMap<Transition, SequencingArtifactMetrics.SummaryPair>();
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> fullMetrics = this.fullContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> halfMetrics = this.halfContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> zeroMetrics = this.zeroContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
        for (Transition transition : Transition.altValues()) {
            List fullMetricsForTransition = (List)fullMetrics.get((Object)transition);
            List zeroMetricsForTransition = (List)zeroMetrics.get((Object)transition);
            if (zeroMetricsForTransition.size() != 1) {
                throw new PicardException("Should have exactly one context-free metric pair for transition: " + (Object)((Object)transition));
            }
            ArrayList<SequencingArtifactMetrics.DetailPair> leadingMetricsForTransition = new ArrayList<SequencingArtifactMetrics.DetailPair>();
            ArrayList<SequencingArtifactMetrics.DetailPair> trailingMetricsForTransition = new ArrayList<SequencingArtifactMetrics.DetailPair>();
            for (SequencingArtifactMetrics.DetailPair metrics : (List)halfMetrics.get((Object)transition)) {
                if (!metrics.preAdapterMetrics.CONTEXT.equals(metrics.baitBiasMetrics.CONTEXT)) {
                    throw new PicardException("Input detail metrics are not matched up properly - contexts differ.");
                }
                boolean isLeading = this.leadingContextMap.containsValue(metrics.preAdapterMetrics.CONTEXT);
                boolean isTrailing = this.trailingContextMap.containsValue(metrics.preAdapterMetrics.CONTEXT);
                if (isLeading) {
                    leadingMetricsForTransition.add(metrics);
                }
                if (!isTrailing) continue;
                trailingMetricsForTransition.add(metrics);
            }
            SequencingArtifactMetrics.DetailPair totalMetric = (SequencingArtifactMetrics.DetailPair)zeroMetricsForTransition.get(0);
            SequencingArtifactMetrics.DetailPair worstFullMetric = this.getWorstMetrics(fullMetricsForTransition);
            SequencingArtifactMetrics.DetailPair worstLeadingMetric = this.getWorstMetrics(leadingMetricsForTransition);
            SequencingArtifactMetrics.DetailPair worstTrailingMetric = this.getWorstMetrics(trailingMetricsForTransition);
            SequencingArtifactMetrics.PreAdapterSummaryMetrics preAdapterSummaryMetrics = new SequencingArtifactMetrics.PreAdapterSummaryMetrics();
            SequencingArtifactMetrics.BaitBiasSummaryMetrics baitBiasSummaryMetrics = new SequencingArtifactMetrics.BaitBiasSummaryMetrics();
            preAdapterSummaryMetrics.SAMPLE_ALIAS = this.sampleAlias;
            preAdapterSummaryMetrics.LIBRARY = this.library;
            preAdapterSummaryMetrics.REF_BASE = transition.ref();
            preAdapterSummaryMetrics.ALT_BASE = transition.call();
            preAdapterSummaryMetrics.TOTAL_QSCORE = totalMetric.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.WORST_CXT = worstFullMetric.preAdapterMetrics.CONTEXT;
            preAdapterSummaryMetrics.WORST_CXT_QSCORE = worstFullMetric.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.WORST_PRE_CXT = worstLeadingMetric.preAdapterMetrics.CONTEXT;
            preAdapterSummaryMetrics.WORST_PRE_CXT_QSCORE = worstLeadingMetric.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.WORST_POST_CXT = worstTrailingMetric.preAdapterMetrics.CONTEXT;
            preAdapterSummaryMetrics.WORST_POST_CXT_QSCORE = worstTrailingMetric.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.inferArtifactName();
            baitBiasSummaryMetrics.SAMPLE_ALIAS = this.sampleAlias;
            baitBiasSummaryMetrics.LIBRARY = this.library;
            baitBiasSummaryMetrics.REF_BASE = transition.ref();
            baitBiasSummaryMetrics.ALT_BASE = transition.call();
            baitBiasSummaryMetrics.TOTAL_QSCORE = totalMetric.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.WORST_CXT = worstFullMetric.baitBiasMetrics.CONTEXT;
            baitBiasSummaryMetrics.WORST_CXT_QSCORE = worstFullMetric.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.WORST_PRE_CXT = worstLeadingMetric.baitBiasMetrics.CONTEXT;
            baitBiasSummaryMetrics.WORST_PRE_CXT_QSCORE = worstLeadingMetric.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.WORST_POST_CXT = worstTrailingMetric.baitBiasMetrics.CONTEXT;
            baitBiasSummaryMetrics.WORST_POST_CXT_QSCORE = worstTrailingMetric.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.inferArtifactName();
            summaryMetricsMap.put(transition, new SequencingArtifactMetrics.SummaryPair(preAdapterSummaryMetrics, baitBiasSummaryMetrics));
        }
        return summaryMetricsMap;
    }

    private ListMap<Transition, SequencingArtifactMetrics.DetailPair> getDetailMetrics() {
        return this.fullContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
    }

    private SequencingArtifactMetrics.DetailPair getWorstMetrics(List<SequencingArtifactMetrics.DetailPair> metrics) {
        SequencingArtifactMetrics.PreAdapterDetailMetrics worstPreAdapterMetrics = null;
        SequencingArtifactMetrics.BaitBiasDetailMetrics worstBaitBiasMetrics = null;
        for (SequencingArtifactMetrics.DetailPair m : metrics) {
            if (worstPreAdapterMetrics == null || m.preAdapterMetrics.QSCORE < worstPreAdapterMetrics.QSCORE) {
                worstPreAdapterMetrics = m.preAdapterMetrics;
            }
            if (worstBaitBiasMetrics != null && !(m.baitBiasMetrics.QSCORE < worstBaitBiasMetrics.QSCORE)) continue;
            worstBaitBiasMetrics = m.baitBiasMetrics;
        }
        return new SequencingArtifactMetrics.DetailPair(worstPreAdapterMetrics, worstBaitBiasMetrics);
    }
}

