/*
 * Decompiled with CFR 0.152.
 */
package projects.talen;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import java.util.HashMap;
import java.util.Iterator;
import projects.talen.InfixMatchFinder;
import projects.talen.LimitedSortedList;
import projects.talen.PartialStringTree;
import projects.talen.SimpleMatchFinder;
import projects.tals.TALgetterDiffSM;

public abstract class MatchFinder {
    protected HashMap<HashEntry, LimitedSortedList<Match>> scoreHash = new HashMap();
    protected HashMap<HashEntry, LimitedSortedList<Match>> scoreHashRc = new HashMap();

    public synchronized void hash(HashEntry en, LimitedSortedList<Match> matches, boolean rc) {
        if (rc) {
            if (this.scoreHashRc.size() > 32) {
                Iterator<HashEntry> it = this.scoreHashRc.keySet().iterator();
                int i = 0;
                while (it.hasNext() && i < 20) {
                    it.next();
                    it.remove();
                }
            }
            this.scoreHashRc.put(en, matches);
        } else {
            if (this.scoreHash.size() > 32) {
                Iterator<HashEntry> it = this.scoreHash.keySet().iterator();
                int i = 0;
                while (it.hasNext() && i < 20) {
                    it.next();
                    it.remove();
                }
            }
            this.scoreHash.put(en, matches);
        }
    }

    public synchronized LimitedSortedList<Match> getHashed(HashEntry en, boolean rc) {
        if (rc) {
            return this.scoreHashRc.get(en);
        }
        return this.scoreHash.get(en);
    }

    public abstract LimitedSortedList<Match> getScoresAbove(Sequence var1, double var2, int var4, boolean var5, boolean var6);

    public static MatchFinder getMatchFinder(DataSet ds, TALgetterDiffSM model, int maxLength) {
        long n = 0L;
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            n += (long)ds.getElementAt(i).getLength();
            ++i;
        }
        if ((double)n < 500000.0) {
            System.out.println("simple");
            return new SimpleMatchFinder(ds, model);
        }
        if ((double)n < 1.0E8) {
            System.out.println("pst");
            return new PartialStringTree(ds, Math.min(11, maxLength), Math.min(14, maxLength), model);
        }
        System.out.println("infix");
        return new InfixMatchFinder(ds, Math.min(8, maxLength), model);
    }

    public void reset() {
        this.scoreHash.clear();
        this.scoreHashRc.clear();
    }

    public static class HashEntry {
        private Sequence tal;
        private Double usedThresh;
        private Integer usedCap;
        private Boolean capBest;

        public HashEntry(Sequence tal, double usedThresh, int usedCap, boolean capBest) {
            this.tal = tal;
            this.usedThresh = usedThresh;
            this.usedCap = usedCap;
            this.capBest = capBest;
        }

        public boolean equals(Object o) {
            if (o instanceof HashEntry) {
                HashEntry en = (HashEntry)o;
                return en.tal.equals(this.tal) && en.usedThresh.equals(this.usedThresh) && en.usedCap.equals(this.usedCap) && en.capBest.equals(this.capBest);
            }
            return false;
        }

        public Sequence getTal() {
            return this.tal;
        }

        public double getUsedThresh() {
            return this.usedThresh;
        }

        public int getUsedCap() {
            return this.usedCap;
        }

        public boolean isCapBest() {
            return this.capBest;
        }

        public int hashCode() {
            int hash = this.tal.hashCode();
            hash = hash * 31 + this.usedThresh.hashCode();
            hash = hash * 31 + this.usedCap.hashCode();
            hash = hash * 31 + this.capBest.hashCode();
            return hash;
        }
    }

    public static class Match {
        private int seqIdx;
        private int seqPos;
        private boolean rc;

        public Match(int seqIdx, int seqPos, boolean rc) {
            this.seqIdx = seqIdx;
            this.seqPos = seqPos;
            this.rc = rc;
        }

        public int getSeqIdx() {
            return this.seqIdx;
        }

        public int getSeqPos() {
            return this.seqPos;
        }

        public boolean isRc() {
            return this.rc;
        }

        public String toString() {
            return "(" + this.seqIdx + ", " + this.seqPos + ", " + this.rc + ")";
        }
    }
}

