/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.ChunkedSymbolListFactory;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderBase;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.PackedSymbolListFactory;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.StaticMemberPlaceHolder;

public class SmartSequenceBuilder
extends SequenceBuilderBase {
    public static final SequenceBuilderFactory FACTORY = new SSBFactory(-1);
    public static final SequenceBuilderFactory BIT_PACKED = new SSBFactory(0);
    private ChunkedSymbolListFactory slFactory;

    private SmartSequenceBuilder(int threshold) {
        this.slFactory = new ChunkedSymbolListFactory(new PackedSymbolListFactory(), threshold);
    }

    public void addSymbols(Alphabet alpha, Symbol[] syms, int pos, int len) throws IllegalAlphabetException {
        this.slFactory.addSymbols(alpha, syms, pos, len);
    }

    public Sequence makeSequence() throws BioException {
        try {
            SymbolList symbols = this.slFactory.makeSymbolList();
            this.seq = new SimpleSequence(symbols, this.uri, this.name, this.annotation);
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            // empty catch block
        }
        return super.makeSequence();
    }

    private static class SSBFactory
    implements SequenceBuilderFactory,
    Serializable {
        private final int threshold;

        private SSBFactory(int threshold) {
            this.threshold = threshold;
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new SmartSequenceBuilder(this.threshold);
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder(SimpleSequenceBuilder.class.getField("FACTORY"));
            }
            catch (NoSuchFieldException nsfe) {
                throw new NotSerializableException(nsfe.getMessage());
            }
        }
    }
}

