/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.util.Stack;
import org.xml.sax.Attributes;

class BaseXMLWriterTestHelper {
    private Stack oElementStack = new Stack();
    private StringBuffer oStr = new StringBuffer();
    private StringBuffer oIndent = new StringBuffer();
    private String oLineSeparator;
    private StringBuffer oSpaceStore = new StringBuffer();
    private boolean tLastWritePCData;
    private String oAttName;
    private String oAttValue;
    static final String oHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public BaseXMLWriterTestHelper() {
        this.oLineSeparator = System.getProperty("line.separator");
        this.oIndent.setLength(0);
        this.tLastWritePCData = false;
    }

    private void decreaseIndent() {
        this.oIndent.setLength(this.oIndent.length() - 2);
    }

    public String endElement() {
        this.decreaseIndent();
        this.oStr.setLength(0);
        if (!this.tLastWritePCData) {
            this.oStr.append(this.nl());
            this.oStr.append(this.indent());
        }
        this.oStr.append("</");
        this.oStr.append((String)this.oElementStack.pop());
        this.oStr.append(">");
        this.tLastWritePCData = false;
        return this.oStr.substring(0);
    }

    private void increaseIndent() {
        this.oIndent.append("  ");
    }

    public String indent() {
        return this.oIndent.substring(0);
    }

    public String nl() {
        return this.oLineSeparator;
    }

    public String startElement(String string) {
        this.oElementStack.push(string);
        this.oStr.setLength(0);
        if (!this.tLastWritePCData) {
            this.oStr.append(this.nl());
        }
        this.oStr.append(this.indent());
        this.oStr.append("<");
        this.oStr.append(string);
        this.oStr.append(">");
        this.increaseIndent();
        this.tLastWritePCData = false;
        return this.oStr.substring(0);
    }

    public String startElement(String string, Attributes attributes) {
        this.oElementStack.push(string);
        this.oStr.setLength(0);
        if (!this.tLastWritePCData) {
            this.oStr.append(this.nl());
        }
        this.oStr.append(this.indent());
        this.oStr.append("<");
        this.oStr.append(string);
        int i = 0;
        this.oSpaceStore.setLength(0);
        this.oSpaceStore.append(this.indent());
        for (i = 0; i <= string.length(); ++i) {
            this.oSpaceStore.append(" ");
        }
        for (i = 0; i < attributes.getLength() - 1; ++i) {
            this.oAttName = attributes.getQName(i);
            this.oAttValue = attributes.getValue(i);
            this.oStr.append(" ");
            if (i > 0) {
                this.oStr.append(this.oSpaceStore.substring(0));
            }
            this.oStr.append(this.oAttName);
            this.oStr.append("=\"");
            this.oStr.append(this.oAttValue);
            this.oStr.append("\"");
            this.oStr.append(this.nl());
        }
        this.oAttName = attributes.getQName(i);
        this.oAttValue = attributes.getValue(i);
        this.oStr.append(" ");
        if (attributes.getLength() > 1) {
            this.oStr.append(this.oSpaceStore.substring(0));
        }
        this.oStr.append(this.oAttName);
        this.oStr.append("=\"");
        this.oStr.append(this.oAttValue);
        this.oStr.append("\"");
        this.oStr.append(">");
        this.increaseIndent();
        this.tLastWritePCData = false;
        return this.oStr.substring(0);
    }

    public String writeEmptyElement(String string) {
        this.oStr.setLength(0);
        if (!this.tLastWritePCData) {
            this.oStr.append(this.nl());
        }
        this.oStr.append(this.indent());
        this.oStr.append("<");
        this.oStr.append(string);
        this.oStr.append("/>");
        this.tLastWritePCData = false;
        return this.oStr.substring(0);
    }

    public String writeEmptyElement(String string, Attributes attributes) {
        this.oStr.setLength(0);
        if (!this.tLastWritePCData) {
            this.oStr.append(this.nl());
        }
        this.oStr.append(this.indent());
        this.oStr.append("<");
        this.oStr.append(string);
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.oAttName = attributes.getQName(i);
            this.oAttValue = attributes.getValue(i);
            this.oStr.append(" ");
            this.oStr.append(this.oAttName);
            this.oStr.append("=\"");
            this.oStr.append(this.oAttValue);
            this.oStr.append("\"");
        }
        this.oStr.append("/>");
        this.tLastWritePCData = false;
        return this.oStr.substring(0);
    }

    public String writeHeader() {
        this.oStr.setLength(0);
        this.oStr.append(oHeader);
        this.tLastWritePCData = false;
        return this.oStr.substring(0);
    }

    public String writePCData(String poPCData) {
        this.oStr.setLength(0);
        this.oStr.append(poPCData);
        this.tLastWritePCData = true;
        return this.oStr.substring(0);
    }
}

