/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.Storable;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.utils.ToolBox;
import java.util.TreeMap;

public final class DoubleList
implements Storable,
Cloneable {
    private int size;
    private double[] array;
    private double[] help;

    public DoubleList() {
        this(10);
    }

    public DoubleList(int size) throws IllegalArgumentException {
        if (size <= 0) {
            throw new IllegalArgumentException("The size has to be positive.");
        }
        this.size = 0;
        this.array = new double[size];
    }

    public DoubleList clone() throws CloneNotSupportedException {
        DoubleList clone = (DoubleList)super.clone();
        clone.array = (double[])this.array.clone();
        clone.help = null;
        return clone;
    }

    public DoubleList(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, this.getClass().getSimpleName());
        this.size = XMLParser.extractObjectForTags(xml, "size", Integer.TYPE);
        this.array = new double[this.size];
        TreeMap<String, String> filter = new TreeMap<String, String>();
        int i = 0;
        while (i < this.size) {
            filter.clear();
            filter.put("val", "" + i);
            this.array[i] = XMLParser.extractObjectAndAttributesForTags(xml, "pos", null, filter, Double.TYPE);
            ++i;
        }
    }

    public void addAll(DoubleList list2) {
        if (this.array.length <= this.size + list2.length()) {
            double[] help = new double[2 * (this.array.length + list2.length())];
            System.arraycopy(this.array, 0, help, 0, this.size);
            this.array = help;
        }
        System.arraycopy(list2.array, 0, this.array, this.size, list2.length());
        this.size += list2.length();
    }

    public final void add(double val) {
        if (this.array.length == this.size) {
            this.help = new double[2 * this.array.length];
            System.arraycopy(this.array, 0, this.help, 0, this.size);
            this.array = this.help;
        }
        this.array[this.size++] = val;
    }

    public void add(double val, int fromIndex, int toIndex) {
        if (toIndex > this.array.length) {
            double[] help = new double[toIndex];
            System.arraycopy(this.array, 0, help, 0, this.size);
            this.array = help;
        }
        while (fromIndex < toIndex) {
            this.array[fromIndex++] = val;
        }
        if (this.size < toIndex) {
            this.size = toIndex;
        }
    }

    public final void clear() {
        this.size = 0;
    }

    public final double get(int index) {
        if (index < this.size) {
            return this.array[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public final int length() {
        return this.size;
    }

    public double[] toArray() {
        double[] erg = new double[this.size];
        System.arraycopy(this.array, 0, erg, 0, this.size);
        return erg;
    }

    public double[] toArray(int start, int end) {
        if (start < 0 || start > end || end >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double[] erg = new double[end - start];
        if (erg.length > 0) {
            System.arraycopy(this.array, start, erg, 0, end - start);
        }
        return erg;
    }

    public void multiply(int start, int end, double factor) {
        while (start < end) {
            int n = start++;
            this.array[n] = this.array[n] * factor;
        }
    }

    public void addTo(int start, int end, double summand) {
        while (start < end) {
            int n = start++;
            this.array[n] = this.array[n] + summand;
        }
    }

    public double mean(int start, int end) {
        return ToolBox.mean(start, end, this.array);
    }

    public double sd(int start, int end) {
        return ToolBox.sd(start, end, this.array);
    }

    public double min(int start, int end) {
        return ToolBox.min(start, end, this.array);
    }

    public double median(int start, int end) {
        return ToolBox.median(start, end, this.array);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(this.size * 30);
        XMLParser.appendObjectWithTags(xml, this.size, "size");
        int i = 0;
        while (i < this.size) {
            XMLParser.appendObjectWithTagsAndAttributes(xml, this.array[i], "pos", "val=\"" + i + "\"");
            ++i;
        }
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i = 0;
        while (i < this.size) {
            sb.append(i == 0 ? "" : ", ");
            sb.append(this.array[i]);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

