/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ParameterSet;

public abstract class InstanceParameterSet<T extends InstantiableFromParameterSet>
extends ParameterSet {
    private Class<? extends T> instanceClass;

    public InstanceParameterSet(Class<? extends T> instanceClass) {
        if (instanceClass == null) {
            throw new IllegalArgumentException("The instanceClass can not be null.");
        }
        this.instanceClass = instanceClass;
    }

    public InstanceParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public Class<? extends T> getInstanceClass() {
        return this.instanceClass;
    }

    public T getInstance() throws ParameterSetParser.NotInstantiableException {
        return ParameterSetParser.getInstanceFromParameterSet(this);
    }

    public abstract String getInstanceComment();

    public abstract String getInstanceName();

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameterSet");
        XMLParser.appendObjectWithTags(buf, this.instanceClass, "instanceClass");
        XMLParser.addTags(buf, "instanceParameterSet");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "instanceParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameterSet"));
        this.instanceClass = XMLParser.extractObjectForTags(representation, "instanceClass", Class.class);
    }
}

