/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased.sampling;

import de.jstacs.NotTrainedException;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.ClassDimensionException;
import de.jstacs.classifiers.differentiableSequenceScoreBased.DiffSSBasedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.sampling.SamplingScoreBasedClassifierParameterSet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.XMLParser;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sampling.BurnInTest;
import de.jstacs.sampling.SamplingComponent;
import de.jstacs.sequenceScores.statisticalModels.differentiable.SamplingDifferentiableStatisticalModel;
import de.jstacs.utils.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import javax.naming.OperationNotSupportedException;

public abstract class SamplingScoreBasedClassifier
extends AbstractScoreBasedClassifier {
    private static Random r = new Random();
    protected SamplingScoreBasedClassifierParameterSet params;
    protected SamplingDifferentiableStatisticalModel[] scoringFunctions;
    protected double[] currentParameters;
    protected double[] initParameters;
    protected double currentScore;
    protected double[] previousParameters;
    protected double[][] lastParameters;
    protected double[] lastScore;
    private int[][] groupedParameters;
    private int[] parameterOffsets;
    private double[] classVariances;
    private double[] samplingSds;
    private boolean isTrained;
    protected BurnInTest burnInTest;
    private Integer burnInLength;
    private DiffSMSamplingComponent samplingComponent;
    private File tempDir;
    private boolean deleteOnExit = true;

    @Override
    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        XMLParser.appendObjectWithTags(xml, this.params, "parameters");
        XMLParser.appendObjectWithTags(xml, this.scoringFunctions, "scoringFunctions");
        XMLParser.appendObjectWithTags(xml, this.currentParameters, "currentParameters");
        XMLParser.appendObjectWithTags(xml, this.initParameters, "initParameters");
        XMLParser.appendObjectWithTags(xml, this.currentScore, "currentScore");
        XMLParser.appendObjectWithTags(xml, this.previousParameters, "previousParameters");
        XMLParser.appendObjectWithTags(xml, this.lastParameters, "lastParameters");
        XMLParser.appendObjectWithTags(xml, this.lastScore, "lastScore");
        XMLParser.appendObjectWithTags(xml, this.groupedParameters, "groupedParameters");
        XMLParser.appendObjectWithTags(xml, this.parameterOffsets, "parametersOffsets");
        XMLParser.appendObjectWithTags(xml, this.classVariances, "classVariances");
        XMLParser.appendObjectWithTags(xml, this.samplingSds, "samplingSds");
        XMLParser.appendObjectWithTags(xml, this.isTrained, "isTrained");
        XMLParser.appendObjectWithTags(xml, this.burnInTest, "burnInTest");
        XMLParser.appendObjectWithTags(xml, this.burnInLength, "burnInLength");
        DiffSMSamplingComponent sfsc = this.getSamplingComponent();
        try {
            StringBuffer sb = sfsc.saveParameters();
            XMLParser.addTags(sb, "sampledParameters");
            xml.append(sb);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return xml;
    }

    @Override
    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        this.params = XMLParser.extractObjectForTags(xml, "parameters", SamplingScoreBasedClassifierParameterSet.class);
        this.scoringFunctions = XMLParser.extractObjectForTags(xml, "scoringFunctions", SamplingDifferentiableStatisticalModel[].class);
        this.currentParameters = XMLParser.extractObjectForTags(xml, "currentParameters", double[].class);
        this.initParameters = XMLParser.extractObjectForTags(xml, "initParameters", double[].class);
        this.currentScore = XMLParser.extractObjectForTags(xml, "currentScore", Double.TYPE);
        this.previousParameters = XMLParser.extractObjectForTags(xml, "previousParameters", double[].class);
        this.lastParameters = XMLParser.extractObjectForTags(xml, "lastParameters", double[][].class);
        this.lastScore = XMLParser.extractObjectForTags(xml, "lastScore", double[].class);
        this.groupedParameters = XMLParser.extractObjectForTags(xml, "groupedParameters", int[][].class);
        this.parameterOffsets = XMLParser.extractObjectForTags(xml, "parameterOffsets", int[].class);
        this.classVariances = XMLParser.extractObjectForTags(xml, "classVariances", double[].class);
        this.samplingSds = XMLParser.extractObjectForTags(xml, "samplingSds", double[].class);
        this.isTrained = XMLParser.extractObjectForTags(xml, "isTrained", Boolean.TYPE);
        this.burnInTest = XMLParser.extractObjectForTags(xml, "burnInTest", BurnInTest.class);
        this.burnInLength = XMLParser.extractObjectForTags(xml, "burnInLength", Integer.class);
        DiffSMSamplingComponent sfsc = this.getSamplingComponent();
        try {
            sfsc.initForSampling(this.params.getNumberOfStarts());
            StringBuffer sb = XMLParser.extractForTag(xml, "sampledParameters");
            sfsc.createFiles(sb);
        }
        catch (Exception e) {
            NonParsableException ex = new NonParsableException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
        }
    }

    public SamplingScoreBasedClassifier(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    protected SamplingScoreBasedClassifier(SamplingScoreBasedClassifierParameterSet params, BurnInTest burnInTest, double[] classVariances, SamplingDifferentiableStatisticalModel ... scoringFunctions) throws CloneNotSupportedException {
        super(params.getAlphabetContainer(), params.getLength(), scoringFunctions.length);
        this.params = params.clone();
        this.scoringFunctions = (SamplingDifferentiableStatisticalModel[])scoringFunctions.clone();
        this.burnInLength = null;
        this.classVariances = (double[])classVariances.clone();
        if (burnInTest != null) {
            this.burnInTest = burnInTest.clone();
        }
    }

    @Override
    public CategoricalResult[] getClassifierAnnotation() {
        CategoricalResult[] res = new CategoricalResult[this.scoringFunctions.length + 1];
        res[0] = new CategoricalResult("classifier", "a <b>short</b> description of the classifier", this.getInstanceName());
        int i = 0;
        while (i < this.scoringFunctions.length) {
            res[i + 1] = new CategoricalResult("class info " + i, "some information about the scoring function for class " + i, this.scoringFunctions[i++].getInstanceName());
        }
        return res;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        NumericalResult[] pars = new NumericalResult[this.scoringFunctions.length];
        int i = 0;
        while (i < this.scoringFunctions.length) {
            pars[i] = new NumericalResult("Number of parameters " + (i + 1), "The number of parameters for scoring function " + (i + 1) + ", -1 indicates unknown number of parameters.", this.scoringFunctions[i].getNumberOfParameters());
            ++i;
        }
        return new NumericalResultSet(new NumericalResult[][]{pars});
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    protected abstract DiffSSBasedOptimizableFunction getFunction(DataSet[] var1, double[][] var2) throws Exception;

    protected double modifyFunctionValue(double value) {
        return value;
    }

    protected DiffSMSamplingComponent getSamplingComponent() {
        if (this.samplingComponent == null) {
            this.samplingComponent = new DiffSMSamplingComponent(this.params.getOutfilePrefix());
        }
        return this.samplingComponent;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
        this.samplingComponent = null;
        this.isTrained = false;
    }

    public boolean getDeleteOnExit() {
        return this.deleteOnExit;
    }

    public void setDeleteOnExit(boolean deleteOnExit) throws Exception {
        if (this.samplingComponent != null && !deleteOnExit) {
            throw new Exception("Cannot revoke delete on exit after creating files.");
        }
        this.deleteOnExit = deleteOnExit;
    }

    protected void init(int starts, boolean adaptVariance, String outfilePrefix) throws Exception {
        int k;
        boolean freeParams = this.params.getFreeParameters();
        int numParams = 0;
        numParams += this.scoringFunctions.length - (freeParams ? 1 : 0);
        LinkedList<int[]> list = new LinkedList<int[]>();
        int[] temp2 = new int[this.scoringFunctions.length - (freeParams ? 1 : 0) + 1];
        int i = 0;
        while (i < temp2.length) {
            temp2[i] = i - 1;
            ++i;
        }
        list.add(temp2);
        this.parameterOffsets = new int[this.scoringFunctions.length + 1];
        i = 0;
        while (i < this.scoringFunctions.length) {
            this.parameterOffsets[i] = numParams;
            this.scoringFunctions[i].initializeFunctionRandomly(freeParams);
            int[][] temp = this.scoringFunctions[i].getSamplingGroups(numParams);
            int j = 0;
            while (j < temp.length) {
                temp2 = new int[temp[j].length + 1];
                temp2[0] = i;
                k = 0;
                while (k < temp[j].length) {
                    temp2[k + 1] = temp[j][k];
                    ++k;
                }
                list.add(temp2);
                ++j;
            }
            numParams += this.scoringFunctions[i].getNumberOfParameters();
            ++i;
        }
        this.parameterOffsets[this.parameterOffsets.length - 1] = numParams;
        this.groupedParameters = (int[][])list.toArray((T[])new int[0][0]);
        this.currentParameters = new double[numParams];
        this.samplingSds = new double[numParams];
        double[] temp = this.getClassWeights();
        int j = 0;
        while (j < temp.length - (freeParams ? 1 : 0)) {
            this.currentParameters[j] = freeParams ? temp[j] - temp[temp.length - 1] : temp[j];
            this.samplingSds[j] = Math.sqrt(this.classVariances[j]);
            ++j;
        }
        int i2 = 0;
        while (i2 < this.scoringFunctions.length) {
            temp = this.scoringFunctions[i2].getCurrentParameterValues();
            System.arraycopy(temp, 0, this.currentParameters, j, temp.length);
            k = 0;
            while (k < temp.length) {
                if (adaptVariance) {
                    try {
                        this.samplingSds[j + k] = Math.sqrt(this.classVariances[i2] * (double)this.scoringFunctions[i2].getSizeOfEventSpaceForRandomVariablesOfParameter(k));
                        if (Double.isNaN(this.samplingSds[j + k])) {
                            this.samplingSds[j + k] = Math.sqrt(this.classVariances[i2]);
                        }
                    }
                    catch (Exception e) {
                        this.samplingSds[j + k] = Math.sqrt(this.classVariances[i2]);
                    }
                } else {
                    this.samplingSds[j + k] = Math.sqrt(this.classVariances[i2]);
                }
                ++k;
            }
            j += temp.length;
            ++i2;
        }
        if (this.initParameters != null && this.initParameters.length == this.currentParameters.length) {
            this.currentParameters = (double[])this.initParameters.clone();
        }
        this.previousParameters = (double[])this.currentParameters.clone();
        this.lastScore = new double[starts];
        Arrays.fill(this.lastScore, Double.NEGATIVE_INFINITY);
        this.lastParameters = new double[starts][];
        this.lastParameters[0] = (double[])this.currentParameters.clone();
        i2 = 1;
        while (i2 < starts) {
            this.lastParameters[i2] = (double[])this.currentParameters.clone();
            k = 0;
            while (k < this.scoringFunctions.length) {
                this.scoringFunctions[k].initializeFunctionRandomly(freeParams);
                System.arraycopy(this.scoringFunctions[k].getCurrentParameterValues(), 0, this.lastParameters[i2], this.parameterOffsets[k], this.parameterOffsets[k + 1] - this.parameterOffsets[k]);
                ++k;
            }
            ++i2;
        }
        DiffSMSamplingComponent sfsc = this.getSamplingComponent();
        sfsc.initForSampling(starts);
    }

    protected double sampleNSteps(DiffSSBasedOptimizableFunction function, DiffSMSamplingComponent component, BurnInTest test, int numSteps, SamplingScheme scheme) throws Exception {
        double newValue = this.currentScore == Double.NEGATIVE_INFINITY ? this.modifyFunctionValue(function.evaluateFunction(this.currentParameters)) : this.currentScore;
        int i = 0;
        while (i < numSteps) {
            double previousValue = newValue;
            if (Double.isNaN(newValue = this.doOneSamplingStep(function, scheme, previousValue))) {
                newValue = previousValue;
            }
            this.currentScore = newValue;
            component.acceptParameters();
            if (test != null) {
                test.setValue(newValue);
            }
            ++i;
        }
        return newValue;
    }

    protected void sample(DiffSMSamplingComponent sfsc, DiffSSBasedOptimizableFunction function) throws Exception {
        int i;
        boolean afterBurnIn = false;
        int numIterations = 0;
        int starts = this.params.getNumberOfStarts();
        int numberOfTestIterations = this.params.getNumberOfTestSamplings();
        int numberOfStationaryIterations = this.params.getNumberOfStationarySamplings();
        SamplingScheme scheme = this.params.getSamplingScheme();
        while (!afterBurnIn) {
            i = 0;
            while (i < starts) {
                sfsc.extendSampling(i, true);
                this.burnInTest.setCurrentSamplingIndex(i);
                this.sampleNSteps(function, sfsc, this.burnInTest, numberOfTestIterations, scheme);
                ++i;
            }
            this.burnInLength = this.burnInTest.getLengthOfBurnIn();
            if ((numIterations += numberOfTestIterations) <= this.burnInLength) continue;
            afterBurnIn = true;
        }
        i = 0;
        while (i < starts) {
            sfsc.extendSampling(i, false);
            this.sampleNSteps(function, sfsc, this.burnInTest, numberOfStationaryIterations - (numIterations - this.burnInLength), scheme);
            ++i;
        }
    }

    protected double doOneSamplingStep(DiffSSBasedOptimizableFunction function, SamplingScheme scheme, double previousValue) throws Exception {
        double returnValue = Double.NaN;
        this.switchPars(0, this.currentParameters.length, false);
        int i = 0;
        while (i < this.scoringFunctions.length) {
            this.currentParameters[i] = r.nextGaussian() * this.samplingSds[i] + this.previousParameters[i];
            ++i;
        }
        if (scheme == SamplingScheme.ALL_PARAMETERS) {
            i = this.scoringFunctions.length;
            while (i < this.currentParameters.length) {
                this.currentParameters[i] = r.nextGaussian() * this.samplingSds[i] + this.previousParameters[i];
                ++i;
            }
            double temp = this.testParameters(function, previousValue);
            if (Double.isNaN(temp)) {
                this.switchPars(0, this.currentParameters.length, true);
            }
            return temp;
        }
        if (scheme == SamplingScheme.FUNCTION_WISE) {
            double temp = this.testParameters(function, previousValue);
            if (!Double.isNaN(temp)) {
                previousValue = temp;
                returnValue = temp;
            }
            this.switchPars(0, this.scoringFunctions.length, Double.isNaN(temp));
            int i2 = 0;
            while (i2 < this.scoringFunctions.length) {
                int j = this.parameterOffsets[i2];
                while (j < this.parameterOffsets[i2 + 1]) {
                    this.currentParameters[i2] = r.nextGaussian() * this.samplingSds[j] + this.previousParameters[j];
                    ++j;
                }
                temp = this.testParameters(function, previousValue);
                if (!Double.isNaN(temp)) {
                    previousValue = temp;
                    returnValue = temp;
                }
                this.switchPars(this.parameterOffsets[i2], this.parameterOffsets[i2 + 1], Double.isNaN(temp));
                ++i2;
            }
            return returnValue;
        }
        if (scheme == SamplingScheme.GROUPED) {
            double temp = this.testParameters(function, previousValue);
            if (!Double.isNaN(temp)) {
                previousValue = temp;
                returnValue = temp;
            }
            this.switchPars(0, this.scoringFunctions.length, Double.isNaN(temp));
            int i3 = 0;
            while (i3 < this.groupedParameters.length) {
                int j = 1;
                while (j < this.groupedParameters[i3].length) {
                    int idx = this.groupedParameters[i3][j];
                    this.currentParameters[idx] = r.nextGaussian() * this.samplingSds[idx] + this.previousParameters[idx];
                    ++j;
                }
                temp = this.testParameters(function, previousValue);
                if (!Double.isNaN(temp)) {
                    previousValue = temp;
                    returnValue = temp;
                }
                this.switchPars(this.groupedParameters[i3], Double.isNaN(temp));
                ++i3;
            }
            return returnValue;
        }
        throw new Exception("Sampling scheme not implemented.");
    }

    private double testParameters(DiffSSBasedOptimizableFunction function, double previousValue) throws DimensionException, EvaluationException {
        double newValue = this.modifyFunctionValue(function.evaluateFunction(this.currentParameters));
        if (Math.log(r.nextDouble()) < newValue - previousValue) {
            return newValue;
        }
        return Double.NaN;
    }

    private void switchPars(int start, int end, boolean rollback) {
        if (rollback) {
            System.arraycopy(this.previousParameters, start, this.currentParameters, start, end - start);
        } else {
            System.arraycopy(this.currentParameters, start, this.previousParameters, start, end - start);
        }
    }

    private void switchPars(int[] idxs, boolean rollback) {
        if (rollback) {
            int i = 1;
            while (i < idxs.length) {
                this.currentParameters[idxs[i]] = this.previousParameters[idxs[i]];
                ++i;
            }
        } else {
            int i = 1;
            while (i < idxs.length) {
                this.previousParameters[idxs[i]] = this.currentParameters[idxs[i]];
                ++i;
            }
        }
    }

    @Override
    protected double getScore(Sequence seq, int cls, boolean check) throws IllegalArgumentException, NotTrainedException, Exception {
        if (check) {
            super.check(seq);
        }
        DiffSMSamplingComponent sfsc = this.getSamplingComponent();
        int starts = this.params.getNumberOfStarts();
        sfsc.initForSampling(starts);
        sfsc.samplingStopped();
        if (this.burnInLength == null) {
            this.precomputeBurnInLength(sfsc);
        }
        double score = 0.0;
        double n = 0.0;
        int i = 0;
        while (i < starts) {
            sfsc.parseParameterSet(i, this.burnInLength);
            while (sfsc.parseNextParameterSet()) {
                this.setParameters(this.currentParameters);
                score += this.getClassWeight(cls) + this.scoringFunctions[cls].getLogScoreFor(seq);
                n += 1.0;
            }
            ++i;
        }
        return score / n;
    }

    @Override
    public double[] getScores(DataSet s) throws Exception {
        if (this.scoringFunctions.length != 2) {
            throw new OperationNotSupportedException("This method is only for 2-class-classifiers.");
        }
        if (s == null) {
            return new double[0];
        }
        this.check(s);
        int starts = this.params.getNumberOfStarts();
        DiffSMSamplingComponent sfsc = this.getSamplingComponent();
        sfsc.initForSampling(starts);
        sfsc.samplingStopped();
        if (this.burnInLength == null) {
            this.precomputeBurnInLength(sfsc);
        }
        double[] scores = new double[s.getNumberOfElements()];
        double n = 0.0;
        int i = 0;
        while (i < starts) {
            sfsc.parseParameterSet(i, this.burnInLength);
            while (sfsc.parseNextParameterSet()) {
                this.setParameters(this.currentParameters);
                int j = 0;
                while (j < scores.length) {
                    Sequence seq = s.getElementAt(j);
                    int n2 = j++;
                    scores[n2] = scores[n2] + (this.getClassWeight(0) - this.getClassWeight(1) + this.scoringFunctions[0].getLogScoreFor(seq) - this.scoringFunctions[1].getLogScoreFor(seq));
                }
                n += 1.0;
            }
            ++i;
        }
        i = 0;
        while (i < scores.length) {
            int n3 = i++;
            scores[n3] = scores[n3] / n;
        }
        return scores;
    }

    public void setInitParameters(double[] parameters) {
        this.initParameters = (double[])parameters.clone();
    }

    private void setParameters(double[] currentParameters) {
        this.setClassWeights(false, currentParameters, 0);
        int i = 0;
        while (i < this.scoringFunctions.length) {
            this.scoringFunctions[i].setParameters(currentParameters, this.parameterOffsets[i]);
            ++i;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isTrained;
    }

    private Pair<DataSet[], double[][]> check(DataSet[] data, double[][] weights) throws ClassDimensionException, WrongAlphabetException, WrongLengthException {
        if (weights != null && data.length != ((double[][])weights).length) {
            throw new IllegalArgumentException("data and weights do not match");
        }
        if (this.scoringFunctions.length != data.length) {
            throw new ClassDimensionException();
        }
        if (weights == null) {
            weights = new double[data.length][];
        }
        DataSet[] reduced = new DataSet[data.length];
        double[][] newWeights = new double[data.length][];
        AlphabetContainer abc = this.getAlphabetContainer();
        int l = this.getLength();
        int i = 0;
        while (i < this.scoringFunctions.length) {
            if (weights[i] != null && data[i].getNumberOfElements() != weights[i].length) {
                throw new IllegalArgumentException("At least for one sample: The dimension of the sample and the weight do not match.");
            }
            if (!abc.checkConsistency(data[i].getAlphabetContainer())) {
                throw new IllegalArgumentException("At least one sample is not defined over the correct alphabets.");
            }
            DataSet.WeightedDataSetFactory wsf = data[i].getElementLength() != l ? new DataSet.WeightedDataSetFactory(DataSet.WeightedDataSetFactory.SortOperation.NO_SORT, data[i], weights[i], l) : new DataSet.WeightedDataSetFactory(DataSet.WeightedDataSetFactory.SortOperation.NO_SORT, data[i], weights[i]);
            reduced[i] = wsf.getDataSet();
            newWeights[i] = wsf.getWeights();
            ++i;
        }
        return new Pair<DataSet[], double[][]>(reduced, newWeights);
    }

    public void doSingleSampling(DataSet[] s, double[][] weights, int numSteps, String outfilePrefix) throws Exception {
        Pair<DataSet[], double[][]> pair = this.check(s, weights);
        s = pair.getFirstElement();
        weights = pair.getSecondElement();
        this.init(1, this.params.getAdaptVariance(), outfilePrefix);
        DiffSSBasedOptimizableFunction function = this.getFunction(s, weights);
        DiffSMSamplingComponent sfsc = this.getSamplingComponent();
        sfsc.extendSampling(0, false);
        this.sampleNSteps(function, sfsc, null, numSteps, this.params.getSamplingScheme());
        sfsc.samplingStopped();
    }

    @Override
    public void train(DataSet[] s, double[][] weights) throws Exception {
        Pair<DataSet[], double[][]> pair = this.check(s, weights);
        s = pair.getFirstElement();
        weights = pair.getSecondElement();
        this.init(this.params.getNumberOfStarts(), this.params.getAdaptVariance(), this.params.getOutfilePrefix());
        DiffSMSamplingComponent sfsc = this.getSamplingComponent();
        if (this.burnInTest != null) {
            this.burnInTest.resetAllValues();
        }
        DiffSSBasedOptimizableFunction function = this.getFunction(s, weights);
        this.sample(sfsc, function);
        sfsc.samplingStopped();
        this.burnInLength = 0;
        this.isTrained = true;
    }

    protected void precomputeBurnInLength(DiffSMSamplingComponent sfsc) throws Exception {
        if (this.burnInTest == null) {
            this.burnInLength = 0;
        }
        int starts = this.params.getNumberOfStarts();
        int i = 0;
        while (i < starts) {
            sfsc.parseParameterSet(i, 0);
            this.burnInTest.setCurrentSamplingIndex(i);
            while (sfsc.parseNextParameterSet()) {
                this.burnInTest.setValue(this.currentScore);
            }
            ++i;
        }
        this.burnInLength = this.burnInTest.getLengthOfBurnIn();
    }

    protected double[] getBestParameters() throws Exception {
        int starts = this.params.getNumberOfStarts();
        DiffSMSamplingComponent sfsc = this.getSamplingComponent();
        double best = Double.NEGATIVE_INFINITY;
        double[] bestParameters = null;
        int i = 0;
        while (i < starts) {
            sfsc.parseParameterSet(i, 0);
            while (sfsc.parseNextParameterSet()) {
                if (!(this.currentScore > best)) continue;
                if (bestParameters == null) {
                    bestParameters = (double[])this.currentParameters.clone();
                } else {
                    System.arraycopy(this.currentParameters, 0, bestParameters, 0, this.currentParameters.length);
                }
                best = this.currentScore;
            }
            ++i;
        }
        return bestParameters;
    }

    protected double[] getMeanParameters(boolean testBurnIn, int minBurnInSteps) throws Exception {
        int starts = this.params.getNumberOfStarts();
        DiffSMSamplingComponent sfsc = this.getSamplingComponent();
        if (testBurnIn && this.burnInLength == null) {
            this.precomputeBurnInLength(sfsc);
        }
        double[] meanParameters = null;
        double n = 0.0;
        int i = 0;
        while (i < starts) {
            double k = 0.0;
            sfsc.parseParameterSet(i, 0);
            while (sfsc.parseNextParameterSet()) {
                if (k >= (double)minBurnInSteps && (!testBurnIn || k > (double)this.burnInLength.intValue())) {
                    if (meanParameters == null) {
                        meanParameters = (double[])this.currentParameters.clone();
                    } else {
                        int j = 0;
                        while (j < this.currentParameters.length) {
                            int n2 = j;
                            meanParameters[n2] = meanParameters[n2] + this.currentParameters[j];
                            ++j;
                        }
                    }
                    n += 1.0;
                }
                k += 1.0;
            }
            ++i;
        }
        i = 0;
        while (i < meanParameters.length) {
            int n3 = i++;
            meanParameters[n3] = meanParameters[n3] / n;
        }
        return meanParameters;
    }

    public void joinAndSetParameterFiles(boolean add, File ... files) throws Exception {
        DiffSMSamplingComponent sfsc;
        boolean b;
        if (this.lastParameters == null) {
            this.init(this.params.getNumberOfStarts(), this.params.getAdaptVariance(), this.params.getOutfilePrefix());
        }
        if (b = (sfsc = this.getSamplingComponent()).joinAndSetParameterFiles(add, files)) {
            if (add) {
                this.params.setNumberOfStarts(this.params.getNumberOfStarts() + files.length);
            } else {
                this.params.setNumberOfStarts(files.length);
            }
        }
    }

    protected class DiffSMSamplingComponent
    implements SamplingComponent {
        private File[] outfiles;
        private PrintWriter curr;
        private SparseStringExtractor extract;
        private String outfilePrefix;
        private boolean inSamplingMode = false;
        private int currSampling;

        public DiffSMSamplingComponent(String outfilePrefix) {
            this.outfilePrefix = outfilePrefix;
            this.currSampling = -1;
        }

        public boolean joinAndSetParameterFiles(boolean add, File[] files) throws Exception {
            int l = -1;
            double[][] newLastParameters = new double[files.length][];
            int i = 0;
            while (i < files.length) {
                SparseStringExtractor ex = new SparseStringExtractor(files[i]);
                while (ex.hasMoreElements()) {
                    String str = ex.nextElement();
                    String[] splt1 = str.split("\t");
                    splt1[1] = splt1[1].substring(1, splt1[1].length() - 1);
                    String[] splt = splt1[1].split(", ");
                    if (l == -1) {
                        l = splt.length;
                        if (SamplingScoreBasedClassifier.this.currentParameters != null && SamplingScoreBasedClassifier.this.currentParameters.length != l) {
                            throw new Exception("Number of parameters does not match scoring functions: expected " + SamplingScoreBasedClassifier.this.currentParameters.length + " but found " + splt.length);
                        }
                    } else if (splt.length != 0 && l != splt.length) {
                        throw new Exception("Numbers of parameters between different files do not match: expected " + l + " but found " + splt.length);
                    }
                    if (ex.hasMoreElements()) continue;
                    newLastParameters[i] = new double[splt.length];
                    int j = 0;
                    while (j < newLastParameters[i].length) {
                        newLastParameters[i][j] = Double.parseDouble(splt[j]);
                        ++j;
                    }
                }
                ++i;
            }
            int off = 0;
            off = add ? this.outfiles.length : 0;
            File[] temp = new File[off + files.length];
            double[][] temp2 = new double[temp.length][];
            if (add) {
                System.arraycopy(this.outfiles, 0, temp, 0, off);
                System.arraycopy(SamplingScoreBasedClassifier.this.lastParameters, 0, temp2, 0, off);
            }
            int i2 = 0;
            while (i2 < files.length) {
                temp[i2 + off] = this.getOutfile(i2 + off);
                FileManager.copy(files[i2].getAbsolutePath(), temp[i2 + off].getAbsolutePath());
                temp2[i2 + off] = newLastParameters[i2];
                ++i2;
            }
            this.outfiles = temp;
            SamplingScoreBasedClassifier.this.lastParameters = temp2;
            if (!add) {
                System.arraycopy(SamplingScoreBasedClassifier.this.lastParameters[0], 0, SamplingScoreBasedClassifier.this.currentParameters, 0, SamplingScoreBasedClassifier.this.currentParameters.length);
            }
            return true;
        }

        @Override
        public boolean parseParameterSet(int sampling, int n) throws Exception {
            this.currSampling = sampling;
            this.extract = new SparseStringExtractor(this.outfiles[sampling]);
            int i = 0;
            while (this.extract.hasMoreElements() && i < n) {
                this.extract.nextElement();
            }
            return this.parseNextParameterSet();
        }

        @Override
        public boolean parseNextParameterSet() {
            if (!this.extract.hasMoreElements()) {
                return false;
            }
            String str = this.extract.nextElement();
            String[] splt1 = str.split("\t");
            splt1[1] = splt1[1].substring(1, splt1[1].length() - 1);
            String[] splt = splt1[1].split(", ");
            if (SamplingScoreBasedClassifier.this.currentParameters.length != splt.length) {
                return false;
            }
            int j = 0;
            while (j < splt.length) {
                SamplingScoreBasedClassifier.this.currentParameters[j] = Double.parseDouble(splt[j]);
                ++j;
            }
            SamplingScoreBasedClassifier.this.currentScore = Double.parseDouble(splt1[0]);
            return true;
        }

        @Override
        public void initForSampling(int starts) throws IOException {
            this.outfiles = new File[starts];
            int i = 0;
            while (i < starts) {
                this.outfiles[i] = this.getOutfile(i);
                ++i;
            }
            this.inSamplingMode = true;
        }

        private File getOutfile(int idx) throws IOException {
            File f = File.createTempFile(this.outfilePrefix, String.valueOf(idx) + ".sam", SamplingScoreBasedClassifier.this.tempDir);
            if (SamplingScoreBasedClassifier.this.deleteOnExit) {
                f.deleteOnExit();
            }
            return f;
        }

        @Override
        public void extendSampling(int sampling, boolean append) throws IOException {
            if (this.currSampling >= 0) {
                System.arraycopy(SamplingScoreBasedClassifier.this.currentParameters, 0, SamplingScoreBasedClassifier.this.lastParameters[this.currSampling], 0, SamplingScoreBasedClassifier.this.currentParameters.length);
                SamplingScoreBasedClassifier.this.lastScore[this.currSampling] = SamplingScoreBasedClassifier.this.currentScore;
            }
            System.arraycopy(SamplingScoreBasedClassifier.this.lastParameters[sampling], 0, SamplingScoreBasedClassifier.this.currentParameters, 0, SamplingScoreBasedClassifier.this.currentParameters.length);
            SamplingScoreBasedClassifier.this.currentScore = SamplingScoreBasedClassifier.this.lastScore[sampling];
            this.currSampling = sampling;
            this.curr = new PrintWriter(new FileOutputStream(this.outfiles[sampling], append));
        }

        @Override
        public void samplingStopped() throws IOException {
            if (this.curr != null) {
                this.curr.close();
            }
            this.inSamplingMode = false;
        }

        @Override
        public boolean isInSamplingMode() {
            return this.inSamplingMode;
        }

        @Override
        public void acceptParameters() throws IOException {
            this.curr.println(String.valueOf(SamplingScoreBasedClassifier.this.currentScore) + "\t" + Arrays.toString(SamplingScoreBasedClassifier.this.currentParameters));
            this.curr.flush();
        }

        protected StringBuffer saveParameters() throws IOException {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.outfiles.length) {
                StringBuffer temp = FileManager.readFile(this.outfiles[i]);
                XMLParser.addTagsAndAttributes(temp, "outfile", "pos=\"i\"");
                sb.append(temp);
                ++i;
            }
            return sb;
        }

        protected void createFiles(StringBuffer contents) throws NonParsableException, IOException {
            HashMap<String, String> posFilter = new HashMap<String, String>();
            int i = 0;
            while (i < this.outfiles.length) {
                posFilter.put("pos", String.valueOf(i));
                StringBuffer temp = XMLParser.extractForTag(contents, "outfile", null, posFilter);
                FileManager.writeFile(this.outfiles[i], (CharSequence)temp);
                ++i;
            }
        }
    }

    public static enum SamplingScheme {
        ALL_PARAMETERS,
        FUNCTION_WISE,
        GROUPED;

    }
}

