/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.SeparateLogPrior;
import de.jstacs.io.NonParsableException;

public class SeparateLaplaceLogPrior
extends SeparateLogPrior {
    private double[] bs;
    private double[] mus;

    public SeparateLaplaceLogPrior(double[] vars, double[] classVars, double[] classMus) {
        super(vars, classVars, classMus);
    }

    public SeparateLaplaceLogPrior(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected void unset() {
        this.bs = null;
        this.mus = null;
    }

    private void computeBs() {
        int num = this.funs.length - (this.freeParameters ? 1 : 0);
        int i = 0;
        while (i < this.funs.length) {
            num += this.funs[i].getNumberOfParameters();
            ++i;
        }
        this.bs = new double[num];
        this.mus = new double[num];
        num = 0;
        while (num < this.funs.length - (this.freeParameters ? 1 : 0)) {
            this.bs[num] = Math.sqrt(this.classVars[num] / 2.0);
            this.mus[num] = this.classMus[num];
            ++num;
        }
        i = 0;
        while (i < this.funs.length) {
            int j = 0;
            while (j < this.funs[i].getNumberOfParameters()) {
                this.bs[num] = Math.sqrt(this.vars[i] * (double)this.funs[i].getSizeOfEventSpaceForRandomVariablesOfParameter(j) / 2.0);
                this.mus[num] = 0.0;
                ++num;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void addGradientFor(double[] params, double[] vector) {
        if (this.bs == null) {
            this.computeBs();
        }
        int j = 0;
        while (j < params.length) {
            int n = j;
            vector[n] = vector[n] - Math.signum(params[j] - this.mus[j]) / this.bs[j];
            ++j;
        }
    }

    @Override
    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        if (this.bs == null) {
            this.computeBs();
        }
        double prior = 0.0;
        int i = 0;
        while (i < x.length) {
            prior -= Math.abs(x[i] - this.mus[i]) / this.bs[i];
            ++i;
        }
        return prior;
    }

    @Override
    public int getDimensionOfScope() {
        if (this.bs == null) {
            return -1;
        }
        return this.bs.length;
    }

    @Override
    public String getInstanceName() {
        return "Separate Laplace prior";
    }
}

