/*
 * Decompiled with CFR 0.152.
 */
package supplementary.cookbook.recipes;

import de.jstacs.NotTrainedException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import de.jstacs.utils.ToolBox;
import java.text.NumberFormat;
import java.util.Arrays;

public class HomogeneousMarkovModel
extends AbstractTrainableStatisticalModel {
    private double[] logProbs;

    public HomogeneousMarkovModel(AlphabetContainer alphabets) throws Exception {
        super(alphabets, 0);
        if (!alphabets.isSimple() || !alphabets.isDiscrete()) {
            throw new Exception("Only simple and discrete alphabets allowed");
        }
        this.logProbs = new double[(int)alphabets.getAlphabetLengthAt(0)];
        Arrays.fill(this.logProbs, -Math.log(this.logProbs.length));
    }

    public HomogeneousMarkovModel(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "homogeneousMarkovModel");
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabets");
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.TYPE);
        this.logProbs = XMLParser.extractObjectForTags(xml, "logProbs", double[].class);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(buf, this.length, "length");
        XMLParser.appendObjectWithTags(buf, this.logProbs, "logProbs");
        XMLParser.addTags(buf, "homogeneousMarkovModel");
        return buf;
    }

    @Override
    public String getInstanceName() {
        return "Homogeneous Markov model of order 0";
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        return 0.0;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return new NumericalResultSet(new NumericalResult("Number of parameters", "The number of parameters this model uses", this.logProbs.length));
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws NotTrainedException, Exception {
        double seqLogProb = 0.0;
        int i = startpos;
        while (i <= endpos) {
            seqLogProb += this.logProbs[sequence.discreteVal(i)];
            ++i;
        }
        return seqLogProb;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        Arrays.fill(this.logProbs, 0.0);
        double w = 1.0;
        int i = 0;
        while (i < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i);
            if (weights != null) {
                w = weights[i];
            }
            int j = 0;
            while (j < seq.getLength()) {
                int n = seq.discreteVal(j);
                this.logProbs[n] = this.logProbs[n] + w;
                ++j;
            }
            ++i;
        }
        double norm = 0.0;
        int i2 = 0;
        while (i2 < this.logProbs.length) {
            norm += this.logProbs[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.logProbs.length) {
            this.logProbs[i2] = Math.log(this.logProbs[i2] / norm);
            ++i2;
        }
    }

    @Override
    public String toString(NumberFormat nf) {
        return ToolBox.toString(this.logProbs, nf);
    }
}

