/*
 * Decompiled with CFR 0.152.
 */
package supplementary;

import de.jstacs.io.RegExFilenameFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;

public class PreambleChecker {
    private static final String[] preamble = new String[]{"/*", " * This file is part of Jstacs.", " *", " * Jstacs is free software: you can redistribute it and/or modify it under the", " * terms of the GNU General Public License as published by the Free Software", " * Foundation, either version 3 of the License, or (at your option) any later", " * version.", " *", " * Jstacs is distributed in the hope that it will be useful, but WITHOUT ANY", " * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR", " * A PARTICULAR PURPOSE. See the GNU General Public License for more details.", " *", " * You should have received a copy of the GNU General Public License along with", " * Jstacs. If not, see <http://www.gnu.org/licenses/>.", " *", " * For more information on Jstacs, visit http://www.jstacs.de", " */"};

    public static void main(String[] args) throws Exception {
        File dir = new File("./");
        System.out.println("java: " + PreambleChecker.check(new RegExFilenameFilter("java", RegExFilenameFilter.Directory.ALLOWED, true, ".*\\.java"), dir, null, null, new String[0]));
        System.out.println("html: " + PreambleChecker.check(new RegExFilenameFilter("html", RegExFilenameFilter.Directory.ALLOWED, true, ".*\\.html"), dir, "<!--", "--!>", "<head>"));
    }

    private static int check(FilenameFilter filter, File dir, String addStart, String addEnd, String ... before) throws Exception {
        File[] f = dir.listFiles(filter);
        int anz = 0;
        File[] fileArray = f;
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            File g = fileArray[n2];
            if (g.isDirectory()) {
                anz += PreambleChecker.check(filter, g, addStart, addEnd, before);
            } else {
                String line;
                BufferedReader r = new BufferedReader(new FileReader(g));
                int i = 0;
                int k = 0;
                while ((line = r.readLine()) != null && i < before.length) {
                    if (line.startsWith(before[i])) {
                        ++i;
                    }
                    k += line.length() + 1;
                }
                boolean missingPreamble = addStart == null ? line != null && !line.startsWith("/*") : line != null && !line.startsWith(addStart);
                r.close();
                if (missingPreamble) {
                    File h = new File(String.valueOf(g.getAbsolutePath()) + ".preamble");
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(g));
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(h));
                    int j = 0;
                    while (j < k) {
                        bos.write(bis.read());
                        ++j;
                    }
                    if (addStart != null) {
                        PreambleChecker.write(bos, addStart);
                    }
                    String[] stringArray = preamble;
                    int n3 = preamble.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray[n4];
                        PreambleChecker.write(bos, s);
                        ++n4;
                    }
                    PreambleChecker.write(bos, addEnd);
                    while ((i = bis.read()) > 0) {
                        bos.write(i);
                    }
                    bis.close();
                    bos.close();
                    boolean b = g.delete();
                    System.out.print(String.valueOf(b) + "\t");
                    b = h.renameTo(g);
                    System.out.print(String.valueOf(b) + "\t");
                    System.out.println(g);
                    if (!b) {
                        h.delete();
                    }
                    ++anz;
                }
            }
            ++n2;
        }
        return anz;
    }

    private static void write(BufferedOutputStream bos, String s) throws IOException {
        if (s != null) {
            bos.write(s.getBytes());
            bos.write(10);
        }
    }
}

