/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.galaxy;

import de.jstacs.DataType;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.DataSetResult;
import de.jstacs.results.ImageResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.MeanResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.SimpleResult;
import de.jstacs.results.StorableResult;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class GalaxyAdaptor {
    private ParameterSet parameters;
    private boolean[] addLine;
    private String toolname;
    private String description;
    private String help;
    private String command;
    private String version;
    private NumberFormat format;
    private NumberFormat expFormat;
    private String labelName;
    private Protocol protocol;
    private boolean exportProtocol;
    private LinkedList<OutputElement> list = new LinkedList();
    private String outfile;
    private String outfileId;
    private String newFilePath;
    private String htmlFilesPath;
    public static String stylesheet = "<style type=\"text/css\">body{font-family:sans-serif;font-size:10pt}\ntable{font-size:10pt;border-spacing:0px}\nth{font-weight:bold}\ndiv.head{font-size:15px;line-height:24px;padding:5px 10px;background:#ebd9b2;border-bottom:solid #d8b365 1px;font-weight:bold}\ndiv.comment{color:grey}\nh2{text-align:center}</style>";
    private static int htmlId = 0;
    private static String[] colors = new String[]{"#99FFFF", "#CCCCFF", "#99FFCC", "#CCFF99", "#FFCC99"};

    public static String getColor(int depth) {
        while (depth >= colors.length) {
            depth -= colors.length;
        }
        return colors[depth];
    }

    public static int getHtmlId() {
        return htmlId++;
    }

    public GalaxyAdaptor(ParameterSet parameters, boolean[] addLine, String toolname, String description, String version, String command, String labelName) {
        this.parameters = parameters;
        this.addLine = addLine == null ? null : (boolean[])addLine.clone();
        this.toolname = toolname;
        this.description = description;
        this.version = version;
        this.help = description;
        this.command = command;
        this.labelName = labelName;
        this.format = NumberFormat.getNumberInstance();
        this.format.setMaximumFractionDigits(3);
        this.format.setMinimumFractionDigits(3);
        this.expFormat = new DecimalFormat("0.00E0");
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setHelp(File helpfile) throws IOException {
        BufferedReader read = new BufferedReader(new FileReader(helpfile));
        String temp = null;
        StringBuffer helpb = new StringBuffer();
        while ((temp = read.readLine()) != null) {
            helpb.append(temp);
            helpb.append("\n");
        }
        this.help = helpb.toString();
    }

    public Protocol getProtocol(boolean exportProtocol) {
        this.exportProtocol = exportProtocol;
        this.protocol = new Protocol();
        return this.protocol;
    }

    public String toGalaxyConfig() throws Exception {
        StringBuffer allBuffer = new StringBuffer();
        XMLParser.appendObjectWithTagsAndAttributes(allBuffer, this.description, "description", null, false);
        allBuffer.append("\n");
        XMLParser.appendObjectWithTagsAndAttributes(allBuffer, String.valueOf(this.command) + " --run $script_file $summary $summary.id $__new_file_path__ $summary.extra_files_path", "command", null, false);
        allBuffer.append("\n");
        StringBuffer descBuffer = new StringBuffer();
        StringBuffer confBuffer = new StringBuffer();
        if (this.labelName != null) {
            XMLParser.addTagsAndAttributes(descBuffer, "param", "type=\"text\" size=\"40\" name=\"" + GalaxyAdaptor.getLegalName(this.toolname) + "_" + this.labelName + "\" label=\"Job name\" value=\"\" optional=\"true\" help=\"Please enter a name for your job that should be used in the history (optional)\"");
        }
        if (this.parameters instanceof SimpleParameterSet) {
            ((SimpleParameterSet)this.parameters).toGalaxy(GalaxyAdaptor.getLegalName(this.toolname), "", 0, descBuffer, confBuffer, this.addLine);
        } else {
            this.parameters.toGalaxy(GalaxyAdaptor.getLegalName(this.toolname), "", 0, descBuffer, confBuffer, false);
        }
        XMLParser.addTags(descBuffer, "inputs");
        confBuffer = GalaxyAdaptor.escape(confBuffer);
        XMLParser.addTagsAndAttributes(confBuffer, "configfile", "name=\"script_file\"");
        XMLParser.addTags(confBuffer, "configfiles");
        allBuffer.append(descBuffer);
        allBuffer.append(confBuffer);
        StringBuffer outBuf = new StringBuffer();
        if (this.labelName != null) {
            XMLParser.addTagsAndAttributes(outBuf, "data", "format=\"html\" name=\"summary\" label=\"#if str($" + GalaxyAdaptor.getLegalName(this.toolname) + "_" + this.labelName + ") == '' then $tool.name + ' on ' + $on_string else $" + GalaxyAdaptor.getLegalName(this.toolname) + "_" + this.labelName + "#\"");
        } else {
            XMLParser.addTagsAndAttributes(outBuf, "data", "format=\"html\" name=\"summary\"");
        }
        XMLParser.addTags(outBuf, "outputs");
        allBuffer.append(outBuf);
        StringBuffer helpBuf = new StringBuffer();
        helpBuf.append(this.help);
        XMLParser.addTags(helpBuf, "help");
        allBuffer.append(helpBuf);
        XMLParser.addTagsAndAttributes(allBuffer, "tool", "id=\"" + GalaxyAdaptor.getLegalName(this.toolname) + "\" name=\"" + this.toolname + "\" version=\"" + this.version + "\" force_history_refresh=\"true\"");
        return allBuffer.toString();
    }

    public void fromGalaxyConfig(String filename) throws Exception {
        StringBuffer buf = new StringBuffer();
        BufferedReader read = new BufferedReader(new FileReader(filename));
        String tmp = null;
        while ((tmp = read.readLine()) != null) {
            buf.append(tmp);
        }
        this.parameters.fromGalaxy(GalaxyAdaptor.getLegalName(this.toolname), buf);
    }

    private String getLROutput(ListResult lr) throws IOException {
        StringBuffer all = new StringBuffer();
        if (lr.getAnnotation() != null) {
            ResultSet annotation = lr.getAnnotation();
            int i = 0;
            while (i < annotation.getNumberOfResults()) {
                Result r = annotation.getResultAt(i);
                DataType d = r.getDatatype();
                if (d != DataType.PNG && d != DataType.HTML && d != DataType.LIST && d != DataType.STORABLE) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("<label>" + r.getName() + ":</label>");
                    sb.append(r.getValue().toString());
                    XMLParser.addTags(sb, "div");
                    all.append(sb);
                }
                ++i;
            }
        }
        StringBuffer list = new StringBuffer();
        ResultSet[] res = lr.getValue();
        int i = 0;
        while (i < res.length) {
            int j;
            boolean newNames = i == 0;
            int k = res[i].getNumberOfResults() - 1;
            if (!newNames) {
                if (k + 1 != res[i - 1].getNumberOfResults()) {
                    newNames = true;
                } else {
                    j = 0;
                    while (j <= k) {
                        if (!res[i].getResultAt(j).getName().equals(res[i - 1].getResultAt(j).getName())) {
                            newNames = true;
                            break;
                        }
                        ++j;
                    }
                }
            }
            if (newNames) {
                if (i != 0) {
                    list.append("</table>");
                }
                list.append("<table border=\"1\">");
                list.append("<tr>");
                j = 0;
                while (j <= k) {
                    list.append("<th>" + res[i].getResultAt(j).getName() + "</th>");
                    ++j;
                }
                list.append("</tr>");
            }
            list.append("<tr>");
            j = 0;
            while (j <= k) {
                if (res[i].getResultAt(j) instanceof SimpleResult) {
                    if (res[i].getResultAt(j).getDatatype() == DataType.DOUBLE || res[i].getResultAt(j).getDatatype() == DataType.FLOAT) {
                        double d = ((Number)res[i].getResultAt(j).getValue()).doubleValue();
                        if (Math.abs(d) < 0.01 && d != 0.0) {
                            list.append("<td>" + this.expFormat.format(d) + "</td>");
                        } else {
                            list.append("<td>" + this.format.format(d) + "</td>");
                        }
                    } else {
                        list.append("<td>" + res[i].getResultAt(j).getValue() + "</td>");
                    }
                } else {
                    list.append("<td>" + this.getOutput(res[i].getResultAt(j)) + "</td>");
                }
                ++j;
            }
            list.append("</tr>");
            ++i;
        }
        list.append("</table>");
        XMLParser.addTags(list, "div");
        all.append(list);
        return all.toString();
    }

    private String getOutput(Result res) throws IOException {
        StringBuffer temp;
        StringBuffer buf = new StringBuffer();
        StringBuffer temp2 = new StringBuffer();
        temp2.append(res.getName());
        XMLParser.addTagsAndAttributes(temp2, "div", "class=\"head\"");
        temp2.append("<br />");
        if (res instanceof SimpleResult) {
            temp = new StringBuffer();
            temp.append(res.getValue().toString().replaceAll("\\n", "<br />"));
            XMLParser.addTags(temp, "div");
            buf.append(temp);
        } else if (res instanceof ListResult) {
            buf.append(this.getLROutput((ListResult)res));
        } else if (res instanceof DataSetResult) {
            buf.append(this.getDataSetOutput((DataSetResult)res));
        } else if (res instanceof StorableResult) {
            buf.append(this.getStorableOutput((StorableResult)res));
        } else if (res instanceof AbstractScoreBasedClassifier.DoubleTableResult) {
            buf.append(this.getDTROutput((AbstractScoreBasedClassifier.DoubleTableResult)res));
        } else if (res instanceof ImageResult) {
            buf.append(this.getIROutput((ImageResult)res));
        } else if (res instanceof FileResult) {
            buf.append(this.getFileOutput((FileResult)res));
        } else if (res instanceof LineBasedResult) {
            buf.append(this.getLBOutput((LineBasedResult)res));
        }
        temp = new StringBuffer();
        temp.append(res.getComment());
        if (res instanceof LinkedImageResult) {
            temp.append("<br />Obtain &quot;" + ((LinkedImageResult)res).getLink().getName() + "&quot; (" + ((LinkedImageResult)res).getLink().getComment() + ") by clicking on the image");
        }
        XMLParser.addTagsAndAttributes(temp, "div", "class=\"comment\"");
        temp.append("<br />");
        buf.append(temp);
        temp2.append(buf);
        return temp2.toString();
    }

    private StringBuffer getLBOutput(LineBasedResult res) {
        StringBuffer sb = new StringBuffer();
        res.reset();
        String line = null;
        while ((line = res.getNextLine(false)) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb;
    }

    private String getDTROutput(AbstractScoreBasedClassifier.DoubleTableResult res) {
        double[][] r = res.getValue();
        StringBuffer sb = new StringBuffer();
        sb.append("<table border=\"1\">");
        int i = 0;
        while (i < r.length) {
            sb.append("<tr>");
            int j = 0;
            while (j < r[i].length) {
                sb.append("<td>" + r[i][j] + "</td>");
                ++j;
            }
            sb.append("</tr>");
            ++i;
        }
        sb.append("</table>");
        return sb.toString();
    }

    private String getIROutput(ImageResult res) throws IOException {
        String name = String.valueOf(GalaxyAdaptor.getLegalName(res.getName())) + GalaxyAdaptor.getHtmlId() + ".";
        String filename = String.valueOf(this.htmlFilesPath) + System.getProperty("file.separator") + name;
        File f = new File(String.valueOf(filename) + "png");
        f.getParentFile().mkdirs();
        BufferedImage img = res.getValue();
        ImageIO.write((RenderedImage)img, "png", f);
        String ext = "png";
        StringBuffer sb = new StringBuffer();
        sb.append("<img src=\"" + name + ext + "\" alt=\"" + res.getName() + "\" width=\"" + img.getWidth() + "\" height=\"" + img.getHeight() + "\"/>");
        if (res instanceof LinkedImageResult) {
            FileResult fr = ((LinkedImageResult)res).getLink();
            XMLParser.addTagsAndAttributes(sb, "a", "href=\"" + fr.getFilename() + "." + fr.getExtension() + "\"");
        }
        return sb.toString();
    }

    private String getFileOutput(FileResult res) {
        return "<a href=\"" + res.getFilename() + "." + res.getExtension() + "\">" + res.getName() + "</a>";
    }

    private String getStorableOutput(StorableResult res) throws IOException {
        String name = String.valueOf(GalaxyAdaptor.getLegalName(res.getName())) + GalaxyAdaptor.getHtmlId() + ".";
        String ext = this.export(String.valueOf(this.htmlFilesPath) + System.getProperty("file.separator") + name, res, null);
        return "<a href=\"" + name + ext + "\">" + res.getName() + "</a>";
    }

    private String getDataSetOutput(DataSetResult res) throws IOException {
        DataSet data = res.getValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (res.getParser() == null) {
            data.save(baos, '>', new SplitSequenceAnnotationParser(":", ";"));
        } else {
            data.save(baos, '>', res.getParser());
        }
        return baos.toString().replaceAll("\\n", "<br />");
    }

    private String getOutput(ResultSet res) throws IOException {
        Result[] ress = null;
        ress = res instanceof MeanResultSet ? ((MeanResultSet)res).getStatistics().getResults() : res.getResults();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ress.length) {
            sb.append(this.getOutput(ress[i]));
            ++i;
        }
        return sb.toString();
    }

    public String export(String filename, Result res, String exportExtension) throws IOException {
        String ee = exportExtension;
        if (res instanceof SimpleResult) {
            if (ee == null) {
                ee = "txt";
            }
            File f = new File(String.valueOf(filename) + ee);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(String.valueOf(filename) + ee);
            pw.println(res.toString());
            pw.close();
            return ee;
        }
        if (res instanceof ListResult) {
            if (ee == null) {
                ee = "tabular";
            }
            File f = new File(String.valueOf(filename) + ee);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(String.valueOf(filename) + ee);
            if (ee.equalsIgnoreCase("gff3")) {
                pw.println("##gff-version 3");
            } else if (ee.equalsIgnoreCase("gff")) {
                pw.println("##gff-version 2");
            }
            ((ListResult)res).print(pw);
            pw.close();
            return ee;
        }
        if (res instanceof DataSetResult) {
            if (ee == null) {
                ee = "fasta";
            }
            File f = new File(String.valueOf(filename) + ee);
            f.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(String.valueOf(filename) + ee);
            if (((DataSetResult)res).getParser() == null) {
                ((DataSetResult)res).getValue().save(fos, '>', new SplitSequenceAnnotationParser(":", ";"));
            } else {
                ((DataSetResult)res).getValue().save(fos, '>', ((DataSetResult)res).getParser());
            }
            fos.close();
            return ee;
        }
        if (res instanceof StorableResult) {
            if (ee == null) {
                ee = "xml";
            }
            File f = new File(String.valueOf(filename) + ee);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(String.valueOf(filename) + ee);
            pw.println(((StorableResult)res).getValue());
            pw.close();
            return ee;
        }
        if (res instanceof AbstractScoreBasedClassifier.DoubleTableResult) {
            if (ee == null) {
                ee = "tabular";
            }
            File f = new File(String.valueOf(filename) + ee);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(String.valueOf(filename) + ee);
            double[][] tab = ((AbstractScoreBasedClassifier.DoubleTableResult)res).getValue();
            int i = 0;
            while (i < tab.length) {
                int j = 0;
                while (j < tab[i].length - 1) {
                    pw.print(String.valueOf(tab[i][j]) + "\t");
                    ++j;
                }
                if (tab[i].length > 0) {
                    pw.println(tab[i][tab[i].length - 1]);
                } else {
                    pw.println();
                }
                ++i;
            }
            pw.close();
            return ee;
        }
        if (res instanceof LinkedImageResult) {
            return this.export(filename, ((LinkedImageResult)res).getLink(), exportExtension);
        }
        if (res instanceof ImageResult) {
            if (ee == null) {
                ee = "png";
            }
            File f = new File(String.valueOf(filename) + ee);
            f.getParentFile().mkdirs();
            BufferedImage img = ((ImageResult)res).getValue();
            ImageIO.write((RenderedImage)img, ee, new File(String.valueOf(filename) + ee));
            return ee;
        }
        if (res instanceof FileResult) {
            String ext = ((FileResult)res).getExtension();
            File f = new File(String.valueOf(filename) + ext);
            f.getParentFile().mkdirs();
            FileManager.copy(((FileResult)res).getValue().getAbsolutePath(), f.getAbsolutePath());
            return ext;
        }
        if (res instanceof LineBasedResult) {
            if (ee == null) {
                ee = "tabular";
            }
            File f = new File(String.valueOf(filename) + ee);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(String.valueOf(filename) + ee);
            if (ee.equalsIgnoreCase("gff3")) {
                pw.println("##gff-version 3");
            } else if (ee.equalsIgnoreCase("gff")) {
                pw.println("##gff-version 2");
            }
            LineBasedResult lbr = (LineBasedResult)res;
            lbr.reset();
            String line = "";
            while ((line = lbr.getNextLine(true)) != null) {
                pw.println(line);
            }
            pw.close();
            return ee;
        }
        return null;
    }

    public void writeOutput() throws IOException {
        StringBuffer summary = new StringBuffer();
        int i = 0;
        boolean exported = false;
        for (OutputElement el : this.list) {
            boolean export = el.export;
            Object res = el.result;
            boolean include = el.includeInSummary;
            String str = null;
            if (include) {
                str = res instanceof Result ? this.getOutput((Result)res) : (res instanceof ResultSet ? this.getOutput((ResultSet)res) : res.toString().replaceAll("\\n", "<br />"));
                summary.append(str);
            }
            if (!export) continue;
            exported = true;
            if (res instanceof Result) {
                String name = String.valueOf(++i) + ": " + ((Result)res).getName();
                String string = this.export(String.valueOf(this.newFilePath) + System.getProperty("file.separator") + "primary_" + this.outfileId + "_" + name + "_visible_", (Result)res, el.exportExtension);
                continue;
            }
            ResultSet rs = (ResultSet)res;
            int j = 0;
            while (j < rs.getNumberOfResults()) {
                String name = String.valueOf(++i) + ": " + rs.getResultAt(j).getName();
                String string = this.export(String.valueOf(this.newFilePath) + System.getProperty("file.separator") + "primary_" + this.outfileId + "_" + name + "_visible_", rs.getResultAt(j), el.exportExtension);
                ++j;
            }
        }
        if (this.protocol != null) {
            CategoricalResult prot = new CategoricalResult("Protocol", "The protocol of this " + this.toolname + " run", this.protocol.toString());
            summary.append(this.getOutput(prot));
            if (this.exportProtocol) {
                this.export(String.valueOf(this.newFilePath) + System.getProperty("file.separator") + "primary_" + this.outfileId + "_" + ++i + "_visible_", prot, null);
            }
        }
        XMLParser.addTags(summary, "body");
        StringBuffer all = new StringBuffer();
        StringBuffer head = new StringBuffer();
        head.append("Summary of " + this.toolname + " results");
        XMLParser.addTags(head, "title");
        all.append(head);
        all.append(stylesheet);
        XMLParser.addTags(all, "head");
        all.append("<h2>" + head + "</h2>");
        all.append(summary);
        XMLParser.addTags(all, "html");
        PrintWriter wr = new PrintWriter(this.outfile);
        wr.println(all);
        wr.close();
    }

    public boolean parse(String[] args) throws Exception {
        if ("--create".equals(args[0])) {
            String str = this.toGalaxyConfig();
            PrintWriter wr = new PrintWriter(args[1]);
            wr.println(str);
            wr.close();
            return false;
        }
        if ("--run".equals(args[0])) {
            this.fromGalaxyConfig(args[1]);
            this.outfile = args[2];
            this.outfileId = args[3];
            this.newFilePath = args[4];
            this.htmlFilesPath = args[5];
            return true;
        }
        return false;
    }

    public void addResult(Result res, boolean export, boolean includeInSummary) {
        this.list.add(new OutputElement(res, export, includeInSummary, null));
    }

    public void addResult(Result res, boolean export, boolean includeInSummary, String exportExtension) {
        this.list.add(new OutputElement(res, export, includeInSummary, exportExtension));
    }

    public void addResultSet(ResultSet res, boolean exportAll, boolean includeInSummary) {
        this.list.add(new OutputElement(res, exportAll, includeInSummary, null));
    }

    public static String getLegalName(String name) {
        return name.replaceAll("[\\s,-:]+", "_");
    }

    private static StringBuffer escape(StringBuffer str) {
        return new StringBuffer(str.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
    }

    public String getHtmlFilesPath() {
        return this.htmlFilesPath;
    }

    public static class FileResult
    extends Result {
        private String path;
        private String filename;
        private String extension;

        public FileResult(String name, String comment, String fullPath) {
            super(name, comment, DataType.FILE);
            int idx = fullPath.lastIndexOf(System.getProperty("file.separator"));
            int extIdx = fullPath.lastIndexOf(".");
            this.path = fullPath.substring(0, idx);
            this.filename = fullPath.substring(idx + 1, extIdx);
            this.extension = fullPath.substring(extIdx + 1);
            this.getValue().getParentFile().mkdirs();
        }

        public FileResult(String name, String comment, String path, String filename, String extension) {
            super(name, comment, DataType.FILE);
            this.path = path;
            this.filename = filename;
            this.extension = extension;
            this.getValue().getParentFile().mkdirs();
        }

        public FileResult(StringBuffer rep) throws NonParsableException {
            super(rep);
        }

        @Override
        public String getXMLTag() {
            return this.getClass().getSimpleName();
        }

        @Override
        protected void appendFurtherInfos(StringBuffer sb) {
            XMLParser.appendObjectWithTags(sb, this.path, "path");
            XMLParser.appendObjectWithTags(sb, this.filename, "filename");
            XMLParser.appendObjectWithTags(sb, this.extension, "extension");
        }

        @Override
        protected void extractFurtherInfos(StringBuffer rep) throws NonParsableException {
            this.path = XMLParser.extractObjectForTags(rep, "path", String.class);
            this.filename = XMLParser.extractObjectForTags(rep, "filename", String.class);
            this.extension = XMLParser.extractObjectForTags(rep, "extension", String.class);
        }

        @Override
        public File getValue() {
            String sep = System.getProperty("file.separator");
            return new File(String.valueOf(this.path) + sep + this.filename + "." + this.extension);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }
    }

    public static abstract class LineBasedResult
    extends Result {
        protected LineBasedResult(String name, String comment, DataType datatype) {
            super(name, comment, datatype);
        }

        public abstract void reset();

        public abstract String getNextLine(boolean var1);
    }

    public static class LinkedImageResult
    extends ImageResult {
        private FileResult link;

        public LinkedImageResult(String name, String comment, BufferedImage image, FileResult link) {
            super(name, comment, image);
            this.link = link;
        }

        public LinkedImageResult(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        @Override
        public String getXMLTag() {
            return this.getClass().getSimpleName();
        }

        @Override
        protected void appendFurtherInfos(StringBuffer sb) {
            XMLParser.appendObjectWithTags(sb, this.link, "link");
        }

        @Override
        protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
            this.link = XMLParser.extractObjectForTags(representation, "link", FileResult.class);
        }

        public FileResult getLink() {
            return this.link;
        }
    }

    private static class OutputElement {
        private Object result;
        private boolean export;
        private boolean includeInSummary;
        private String exportExtension;

        private OutputElement(Object result, boolean export, boolean includeInSummary, String exportExtension) {
            this.result = result;
            this.export = export;
            this.includeInSummary = includeInSummary;
            this.exportExtension = exportExtension;
        }
    }

    public static class Protocol {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private PrintWriter wr = new PrintWriter(this.baos);

        private Protocol() {
        }

        public void append(String str) {
            this.wr.append(str);
        }

        public PrintWriter getWriter() {
            return this.wr;
        }

        public ByteArrayOutputStream getOutputStream() {
            return this.baos;
        }

        public void appendHeading(String str) {
            this.wr.append("<strong>" + str + "</strong>\n");
            this.wr.flush();
        }

        public void appendWarning(String str) {
            this.wr.append("<em>" + str + "</em>\n");
            this.wr.flush();
        }

        public String toString() {
            this.wr.flush();
            return this.baos.toString().replaceAll("\n", "<br />");
        }
    }
}

