/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.Rangeable;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.utils.galaxy.GalaxyAdaptor;

public class SelectionParameter
extends AbstractSelectionParameter
implements Rangeable,
GalaxyConvertible {
    private int selected;
    private int defaultSelected;

    public SelectionParameter(DataType datatype, String[] keys, Object[] values, String name, String comment, boolean required) throws AbstractSelectionParameter.InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        this(datatype, keys, values, null, name, comment, required);
    }

    public SelectionParameter(DataType datatype, String[] keys, Object[] values, String[] comments, String name, String comment, boolean required) throws AbstractSelectionParameter.InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        super(datatype, keys, values, comments, name, comment, required);
    }

    public SelectionParameter(String name, String comment, boolean required, ParameterSet ... values) {
        super(name, comment, required, values);
    }

    public SelectionParameter(String name, String comment, boolean required, Class<? extends ParameterSet> ... values) {
        super(name, comment, required, values);
    }

    public SelectionParameter(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    public boolean hasDefault() {
        return this.defaultSelected > -1;
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        if (this.getValue() instanceof ParameterSet) {
            if (!((ParameterSet)this.getValue()).hasDefaultOrIsSet()) {
                if (((ParameterSet)this.getValue()).getErrorMessage() != null) {
                    this.errorMessage = "Selected value has the following error: " + ((ParameterSet)this.getValue()).getErrorMessage();
                }
                return false;
            }
            return true;
        }
        return this.isSet() || this.selected == this.defaultSelected;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getXMLTag() {
        return "collectionParameter";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        super.appendFurtherInfos(buf);
        XMLParser.appendObjectWithTags(buf, this.selected, "selected");
        XMLParser.appendObjectWithTags(buf, this.defaultSelected, "defaultSelected");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        super.extractFurtherInfos(representation);
        this.selected = XMLParser.extractObjectForTags(representation, "selected", Integer.TYPE);
        this.defaultSelected = XMLParser.extractObjectForTags(representation, "defaultSelected", Integer.TYPE);
    }

    @Override
    public boolean isSelected(int idx) {
        return idx == this.selected;
    }

    public int getSelected() {
        return this.selected;
    }

    protected int getDefault() {
        return this.defaultSelected;
    }

    @Override
    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        int i = this.check(value);
        if (i < 0) {
            throw new SimpleParameter.IllegalValueException(this.errorMessage);
        }
        this.selected = i;
        this.userSelected = true;
        if (value instanceof ParameterSetContainer) {
            this.parameters.getParameterAt(this.selected).setValue(((ParameterSetContainer)value).getValue());
        } else if (value instanceof ParameterSet) {
            this.parameters.getParameterAt(this.selected).setValue(value);
        }
    }

    @Override
    public void setDefault(Object defaultValue) throws SimpleParameter.IllegalValueException {
        this.setValue(defaultValue);
        this.defaultSelected = this.selected;
        this.userSelected = false;
    }

    @Override
    public void reset() {
        this.selected = this.defaultSelected;
    }

    @Override
    public Object getValue() {
        if (this.selected < this.parameters.getNumberOfParameters()) {
            return this.parameters.getParameterAt(this.selected).getValue();
        }
        return null;
    }

    public String toString() {
        String s = this.parameters.getParameterAt(0).getName();
        int i = 1;
        while (i < this.parameters.getNumberOfParameters()) {
            s = String.valueOf(s) + ", " + this.parameters.getParameterAt(i).getName();
            ++i;
        }
        return String.valueOf(this.name) + " (" + this.comment + ", range={" + s + "}" + (this.defaultSelected >= 0 ? ", default = " + this.parameters.getParameterAt(this.defaultSelected).getValue() : "") + (this.isRequired() ? "" : ", OPTIONAL") + ")\t= " + this.getValue();
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        namePrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.getName());
        String selected = XMLParser.extractForTag(command, namePrefix).toString();
        this.setValue(selected);
        if (this.getValue() instanceof GalaxyConvertible) {
            ((GalaxyConvertible)this.getValue()).fromGalaxy(String.valueOf(namePrefix) + "_opt" + this.getSelected(), command);
        }
    }
}

