/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.tools;

public class SummaryStats {
    public static double mean(double[] dat) {
        return SummaryStats.sum(dat) / (double)dat.length;
    }

    public static double mean(Double[] dat) {
        return SummaryStats.sum(dat) / (double)dat.length;
    }

    public static double sum(Double[] dat) {
        double total = 0.0;
        for (int i = 0; i < dat.length; ++i) {
            total += dat[i].doubleValue();
        }
        return total;
    }

    public static double sum(double[] dat) {
        double total = 0.0;
        for (int i = 0; i < dat.length; ++i) {
            total += dat[i];
        }
        return total;
    }

    public static int sum(Integer[] dat) {
        int total = 0;
        for (int i = 0; i < dat.length; ++i) {
            total += dat[i].intValue();
        }
        return total;
    }

    public static int sum(int[] dat) {
        int total = 0;
        for (int i = 0; i < dat.length; ++i) {
            total += dat[i];
        }
        return total;
    }

    public static int mean(int[] dat) {
        return SummaryStats.sum(dat) / dat.length;
    }

    public static int mean(Integer[] dat) {
        return SummaryStats.sum(dat) / dat.length;
    }

    public static double variance(double[] dat, double mean) {
        double total = 0.0;
        for (int i = 0; i < dat.length; ++i) {
            total += Math.pow(dat[i] - mean, 2.0);
        }
        return total / (double)(dat.length - 1);
    }

    public static double covariance(double[] dat1, double[] dat2) {
        double mean1 = SummaryStats.mean(dat1);
        double mean2 = SummaryStats.mean(dat2);
        return SummaryStats.covariance(dat1, mean1, dat2, mean2);
    }

    public static double covariance(double[] dat1, double mean1, double[] dat2, double mean2) {
        if (dat1.length != dat2.length) {
            throw new IllegalArgumentException("dat1 and dat2 must be the same length");
        }
        double total = 0.0;
        for (int i = 0; i < dat1.length; ++i) {
            total += (dat1[i] - mean1) * (dat2[i] - mean2);
        }
        return total / (double)(dat1.length - 1);
    }

    public static double correlation(double[] dat1, double[] dat2) {
        return SummaryStats.correlation(dat1, SummaryStats.mean(dat1), dat2, SummaryStats.mean(dat2));
    }

    public static double correlation(double[] dat1, double mean1, double[] dat2, double mean2) {
        if (dat1.length != dat2.length) {
            throw new IllegalArgumentException("dat1 and dat2 must be the same length");
        }
        double total = 0.0;
        for (int i = 0; i < dat1.length; ++i) {
            total += (dat1[i] - mean1) * (dat2[i] - mean2);
        }
        return total / (double)(dat1.length - 1) / Math.sqrt(SummaryStats.variance(dat1, mean1) * SummaryStats.variance(dat2, mean2));
    }

    public static double covariance(int[] dat1, int[] dat2) {
        int mean1 = SummaryStats.mean(dat1);
        int mean2 = SummaryStats.mean(dat2);
        return SummaryStats.covariance(dat1, mean1, dat2, mean2);
    }

    public static double covariance(int[] dat1, int mean1, int[] dat2, int mean2) {
        if (dat1.length != dat2.length) {
            throw new IllegalArgumentException("dat1 and dat2 must be the same length");
        }
        double total = 0.0;
        for (int i = 0; i < dat1.length; ++i) {
            total += (double)((dat1[i] - mean1) * (dat2[i] - mean2));
        }
        return total / (double)(dat1.length - 1);
    }

    public static double variance(Double[] dat, double mean) {
        double total = 0.0;
        for (int i = 0; i < dat.length; ++i) {
            total += Math.pow(dat[i] - mean, 2.0);
        }
        return total / (double)(dat.length - 1);
    }

    public static double variance(Double[] dat) {
        return SummaryStats.variance(dat, SummaryStats.mean(dat));
    }

    public static double variance(double[] dat) {
        return SummaryStats.variance(dat, SummaryStats.mean(dat));
    }

    public static double skew(Double[] dat, double mean, double var) {
        double m3 = 0.0;
        double n = dat.length;
        for (int i = 0; i < dat.length; ++i) {
            m3 += Math.pow(dat[i] - mean, 3.0);
        }
        double g1 = (m3 /= n) / Math.pow(var, 1.5);
        return Math.sqrt(n * (n - 1.0)) * g1 / (n - 2.0);
    }

    public static double skew(double[] dat, double mean, double var) {
        double m3 = 0.0;
        double n = dat.length;
        for (int i = 0; i < dat.length; ++i) {
            m3 += Math.pow(dat[i] - mean, 3.0);
        }
        double g1 = (m3 /= n) / Math.pow(var, 1.5);
        return Math.sqrt(n * (n - 1.0)) * g1 / (n - 2.0);
    }

    public static double skew(Double[] dat) {
        double mean = SummaryStats.mean(dat);
        double var = SummaryStats.variance(dat, mean);
        return SummaryStats.skew(dat, mean, var);
    }

    public static double skew(double[] dat) {
        double mean = SummaryStats.mean(dat);
        double var = SummaryStats.variance(dat, mean);
        return SummaryStats.skew(dat, mean, var);
    }

    public static double max(double[] dat) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dat.length; ++i) {
            if (!(dat[i] > max)) continue;
            max = dat[i];
        }
        return max;
    }

    public static double min(double[] dat) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < dat.length; ++i) {
            if (!(dat[i] < min)) continue;
            min = dat[i];
        }
        return min;
    }

    public static int max(int[] dat) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < dat.length; ++i) {
            if (dat[i] <= max) continue;
            max = dat[i];
        }
        return max;
    }

    public static int min(int[] dat) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < dat.length; ++i) {
            if (dat[i] >= min) continue;
            min = dat[i];
        }
        return min;
    }
}

