/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly.qc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class ScaffoldExporter {
    private File outFile;
    private PrintStream out;
    Map<String, Integer> counts;

    public ScaffoldExporter(File file) throws IOException {
        this.outFile = file;
        this.out = new PrintStream(this.outFile);
        this.counts = new HashMap<String, Integer>();
    }

    public void export(String hdr, StringBuilder sequence, int left, int right) {
        int subSeq = -1;
        subSeq = this.counts.containsKey(hdr) ? this.counts.get(hdr) + 1 : 1;
        this.out.println(">" + hdr + "-");
        this.out.println(sequence.substring(left - 1, right));
        this.counts.put(hdr, subSeq);
    }

    public void export(String hdr, StringBuilder sequence) {
        this.out.println(">" + hdr);
        this.out.println(sequence.toString());
    }

    public void close() {
        this.out.close();
    }
}

