/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly.qc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;
import org.halophiles.assembly.qc.MatchPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadCluster {
    private static int COUNT = 0;
    static int RDLEN = 50;
    int xMax;
    int xMin;
    int yMax;
    int yMin;
    private Set<MatchPoint> points;
    final int id = ++COUNT;

    public ReadCluster(Set<MatchPoint> points) {
        this.xMax = Integer.MIN_VALUE;
        this.xMin = Integer.MAX_VALUE;
        this.yMax = Integer.MIN_VALUE;
        this.yMin = Integer.MAX_VALUE;
        Iterator<MatchPoint> it = points.iterator();
        int i = 0;
        while (it.hasNext()) {
            MatchPoint tmp = it.next();
            if (tmp.x() + RDLEN > this.xMax) {
                this.xMax = tmp.x() + RDLEN;
            }
            if (tmp.x() < this.xMin) {
                this.xMin = tmp.x();
            }
            if (tmp.y() + RDLEN > this.yMax) {
                this.yMax = tmp.y() + RDLEN;
            }
            if (tmp.y() < this.yMin) {
                this.yMin = tmp.y();
            }
            ++i;
        }
        this.points = points;
    }

    public int size() {
        return this.points.size();
    }

    public Set<MatchPoint> getMatchPoints() {
        return this.points;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.xMin + "-" + this.xMax + " <-> " + this.yMin + "-" + this.yMax;
    }

    public void print(File file) throws IOException {
        file.createNewFile();
        PrintStream out = new PrintStream(file);
        for (MatchPoint tmp : this.points) {
            out.println(tmp.x() + "\t" + tmp.y());
        }
        out.close();
    }
}

