/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly.qc;

import java.util.Set;
import java.util.TreeSet;
import org.halophiles.assembly.qc.SpatialClusterer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchPoint {
    private int x;
    private int y;
    MatchPoint pred = null;
    MatchPoint incoming = null;
    Set<MatchPoint> neighbors;
    private boolean visited;
    private boolean noise;
    private boolean assigned;

    public MatchPoint(int x, int y) {
        this.x = x;
        this.y = y;
        this.visited = false;
        this.noise = false;
        this.assigned = false;
    }

    public void addNeighbor(MatchPoint p) {
        if (this.neighbors == null) {
            this.neighbors = new TreeSet<MatchPoint>(SpatialClusterer.xSort);
        }
        this.neighbors.add(p);
    }

    public Set<MatchPoint> getNeighbors() {
        return this.neighbors;
    }

    public int size() {
        return this.neighbors == null ? 0 : this.neighbors.size();
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public void setAssigned() {
        this.assigned = true;
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    public void setNoise() {
        this.noise = true;
    }

    public boolean isNoise() {
        return this.noise;
    }

    public void setVisited() {
        this.visited = true;
    }

    public boolean isVisited() {
        return this.visited;
    }
}

