/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly.qc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.TreeSet;
import org.halophiles.assembly.Contig;

public class MatchBuilder {
    private static final Comparator<int[]> COMP = new Comparator<int[]>(){

        @Override
        public int compare(int[] arg1, int[] arg2) {
            if (arg1[0] == arg2[0]) {
                return 0;
            }
            if (arg1[1] == arg2[1]) {
                return 0;
            }
            if (arg1[0] < arg2[0]) {
                return -1;
            }
            return 1;
        }
    };
    private Contig ctg1;
    private Contig ctg2;
    private int nPairs = 0;
    private TreeSet<int[]> v1;

    public MatchBuilder(Contig ctg1, Contig ctg2) throws IOException {
        if (ctg1 == ctg2) {
            this.ctg1 = ctg1;
            this.ctg2 = ctg2;
        } else {
            this.ctg1 = ctg1;
            this.ctg2 = ctg2;
        }
        this.v1 = new TreeSet<int[]>(COMP);
    }

    public void addMatch(int pos1, int pos2) {
        int[] ar = new int[]{pos1, pos2};
        this.v1.add(ar);
    }

    public void print(File file) throws IOException {
        file.createNewFile();
        PrintStream out = new PrintStream(file);
        for (int[] tmp : this.v1) {
            out.println(tmp[0] + "\t" + tmp[1]);
        }
        out.close();
    }

    public int getNumPairs() {
        return this.nPairs;
    }

    public int[][] getMatches() {
        int[][] ret = new int[this.v1.size()][];
        this.v1.toArray((T[])ret);
        return ret;
    }

    public Contig getContig1() {
        return this.ctg1;
    }

    public Contig getContig2() {
        return this.ctg2;
    }
}

