/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly.qc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.halophiles.assembly.ReadPair;
import org.halophiles.assembly.ReadSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMClusterer {
    private static long SEED = 1000L;
    private Random rand = new Random(SEED++);
    private ReadPair[] reads;
    private double[][] P;
    private int[] C;
    private ReadSet[] clusters;
    private double[] MU;
    private double[] SD;
    private double[] MU_last;
    private double[] SD_last;
    private double L;

    public EMClusterer(Collection<ReadPair> reads, int k) {
        int i;
        this.reads = new ReadPair[reads.size()];
        this.P = new double[reads.size()][k];
        this.C = new int[reads.size()];
        this.clusters = new ReadSet[k];
        this.MU = new double[k];
        this.SD = new double[k];
        this.MU_last = new double[k];
        this.SD_last = new double[k];
        for (i = 0; i < this.clusters.length; ++i) {
            this.clusters[i] = new ReadSet(i);
        }
        Iterator<ReadPair> it = reads.iterator();
        i = 0;
        int c = 0;
        while (it.hasNext()) {
            this.reads[i] = it.next();
            this.C[i] = c = this.rand.nextInt(k);
            this.clusters[c].add(this.reads[i]);
            ++i;
        }
        this.maximize();
    }

    public int iterate(int I, double minDelta) {
        double delta = 0.0;
        int i = 0;
        for (i = 0; i < I; ++i) {
            int j;
            this.maximize();
            this.expect();
            for (j = 0; j < this.clusters.length; ++j) {
                this.MU[j] = this.clusters[j].mean();
                this.SD[j] = this.clusters[j].sd();
            }
            delta = 0.0;
            for (j = 0; j < this.clusters.length; ++j) {
                delta += Math.abs(this.MU[j] - this.MU_last[j]) / this.MU_last[j];
            }
            if ((delta /= (double)this.clusters.length) < minDelta) break;
        }
        return i;
    }

    public Collection<ReadSet> getClusters() {
        HashSet<ReadSet> ret = new HashSet<ReadSet>();
        for (int i = 0; i < this.clusters.length; ++i) {
            ret.add(this.clusters[i]);
        }
        return ret;
    }

    private void expect() {
        double U = 0.0;
        int next = 0;
        this.L = 0.0;
        for (int i = 0; i < this.reads.length; ++i) {
            U = this.rand.nextDouble();
            next = Arrays.binarySearch(this.P[i], U);
            if (next < 0) {
                next = -(next + 1);
            }
            if (this.C[i] != next) {
                this.clusters[this.C[i]].remove(this.reads[i]);
                this.clusters[next].add(this.reads[i]);
                this.C[i] = next;
            }
            if (next == 0) {
                this.L += Math.log(this.P[i][0]);
                continue;
            }
            this.L += Math.log(this.P[i][next] - this.P[i][next - 1]);
        }
    }

    private void maximize() {
        for (int i = 0; i < this.clusters.length; ++i) {
            this.MU_last[i] = this.clusters[i].mean();
            this.SD_last[i] = this.clusters[i].sd();
        }
        this.L = 0.0;
        for (int i = 0; i < this.reads.length; ++i) {
            int j;
            double total = 0.0;
            for (j = 0; j < this.clusters.length; ++j) {
                double p = EMClusterer.p(this.clusters[j].mean(), this.clusters[j].sd(), this.reads[i].getInsert());
                this.L += Math.log(p);
                this.P[i][j] = total += p;
            }
            for (j = 0; j < this.clusters.length; ++j) {
                this.P[i][j] = this.P[i][j] / total;
            }
        }
    }

    public double likelihood() {
        return this.L;
    }

    private static double p(double mu, double sd, double x) {
        double den = 2.0 * sd * sd;
        return Math.exp(-Math.pow(mu - x, 2.0) / den) / Math.sqrt(Math.PI * den);
    }
}

