/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.halophiles.assembly.Contig;
import org.halophiles.assembly.ReadPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMFileParser {
    private HashMap<String, Contig> contigs = new HashMap();
    private HashMap<String, ReadPair> reads = new HashMap();
    private BufferedReader br = null;
    private int nreads;
    private int npairs;
    private int rdlen;
    private File samFile;

    public SAMFileParser(String samPath) throws IOException {
        this(samPath, Integer.MAX_VALUE);
    }

    public SAMFileParser(String samPath, int maxPairs) throws IOException {
        String ctgStr = null;
        this.nreads = 0;
        this.npairs = 0;
        this.samFile = new File(samPath);
        this.br = this.samFile.getName().endsWith(".gz") || this.samFile.getName().endsWith(".Z") || this.samFile.getName().endsWith(".z") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.samFile)))) : new BufferedReader(new FileReader(this.samFile));
        String[] hdr = null;
        String name = null;
        while (SAMFileParser.nextCharIs(this.br, '@')) {
            hdr = this.br.readLine().split("\t");
            if (!hdr[0].equals("@SQ")) continue;
            int len = -1;
            for (String s : hdr) {
                if (s.startsWith("SN")) {
                    name = s.substring(3);
                    continue;
                }
                if (!s.startsWith("LN")) continue;
                len = Integer.parseInt(s.substring(3));
            }
            if (name == null) {
                System.err.println("Found nameless contig in SAM header");
            } else if (len == -1) {
                System.err.println("Found contig of unknown length in SAM header");
            }
            this.contigs.put(name, new Contig(name, len));
        }
        if (this.contigs.size() == 0) {
            System.err.println("0 contigs found in SAM header.");
        }
        ReadPair tmp = null;
        String[] line = null;
        Contig tmpCtg = null;
        int val = -1;
        while (this.br.ready() && this.npairs < maxPairs) {
            line = this.br.readLine().split("\t");
            int left = Integer.parseInt(line[3]);
            if (left == 0) continue;
            boolean rev = SAMFileParser.isReverse(line[1]);
            int len = 0;
            if (line[5].contains("M")) {
                len = SAMFileParser.cigarLength(line[5]);
            }
            ctgStr = line[2];
            if (len <= 0 || ctgStr.equals("*")) continue;
            if (this.reads.containsKey(line[0])) {
                tmp = this.reads.get(line[0]);
            } else {
                tmp = new ReadPair(line[0]);
                this.reads.put(line[0], tmp);
            }
            if (this.contigs.containsKey(ctgStr)) {
                tmpCtg = this.contigs.get(ctgStr);
            } else {
                tmpCtg = new Contig(ctgStr);
                this.contigs.put(ctgStr, tmpCtg);
            }
            val = tmp.addRead(left, rev, len, tmpCtg, Integer.parseInt(line[4]), line[5]);
            if (val == 2) {
                ++this.npairs;
            } else if (val == -1) {
                System.err.println("ambiguous mapping for read " + line[0]);
            }
            tmpCtg.addRead(len);
            ++this.nreads;
            line = null;
        }
    }

    public boolean hasMoreReads() {
        try {
            return this.br.ready();
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getBasename() {
        if (this.samFile.getName().endsWith(".sam")) {
            return this.samFile.getName().substring(0, this.samFile.getName().indexOf(".sam"));
        }
        return this.samFile.getName();
    }

    public Iterator<Contig> getContigs() {
        return this.contigs.values().iterator();
    }

    public Iterator<ReadPair> getReadPairs() {
        return this.reads.values().iterator();
    }

    public int getReadLength() {
        return this.rdlen;
    }

    public int getNumContigs() {
        return this.contigs.size();
    }

    public int getNumReads() {
        return this.nreads;
    }

    public int getNumPairs() {
        return this.npairs;
    }

    private static boolean nextCharIs(BufferedReader br, char c) throws IOException {
        if (!br.ready()) {
            return false;
        }
        boolean ret = false;
        br.mark(1);
        char b = (char)br.read();
        ret = b == c;
        br.reset();
        return ret;
    }

    public static boolean isReverse(String flag) {
        int iflag = Integer.parseInt(flag);
        return SAMFileParser.getBit(4, iflag) == 1;
    }

    public static int getBit(int bit, int flag) {
        int mod = 0;
        for (int dig = 0; flag != 0 && dig <= bit; flag /= 2, ++dig) {
            mod = flag % 2;
        }
        return mod;
    }

    public static int cigarLength(String cig) {
        StringTokenizer tok = new StringTokenizer(cig, "MIDNSHP", true);
        int totalLen = 0;
        int alignLen = 0;
        while (tok.hasMoreTokens()) {
            int len = Integer.parseInt(tok.nextToken());
            char op = tok.nextToken().charAt(0);
            if (op == 'M') {
                alignLen += len;
            }
            if (op == 'I') continue;
            totalLen += len;
        }
        return alignLen;
    }
}

