/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.halophiles.assembly.ReadPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadSet {
    private static NumberFormat NF = NumberFormat.getInstance();
    private static int COUNT = 0;
    private Map<String, ReadPair> reads;
    private double sd;
    private double mu;
    private int nSd;
    private final int ID;
    private boolean mod;

    public ReadSet(int id) {
        this.ID = id;
        this.reads = new HashMap<String, ReadPair>();
        this.mod = false;
    }

    public ReadSet() {
        this.ID = COUNT++;
        this.reads = new HashMap<String, ReadPair>();
        this.mod = false;
    }

    public void add(ReadPair read) {
        this.reads.put(read.hdr, read);
        this.mod = true;
    }

    public void remove(ReadPair read) {
        this.reads.remove(read.hdr);
        this.mod = true;
    }

    public Collection<ReadPair> getReads() {
        return new Vector<ReadPair>(this.reads.values());
    }

    public Collection<String> getReadHdrs() {
        return new Vector<String>(this.reads.keySet());
    }

    public String toString() {
        this.update();
        NF.setMaximumFractionDigits(0);
        NF.setGroupingUsed(false);
        return "id=" + this.ID + ":mu=" + NF.format(this.mu) + ":sd=" + NF.format(this.sd) + ":n=" + this.reads.size();
    }

    public double mean() {
        this.update();
        return this.mu;
    }

    public double sd() {
        this.update();
        return this.sd;
    }

    public int nSd() {
        this.update();
        return this.nSd;
    }

    public int size() {
        return this.reads.size();
    }

    public int getId() {
        return this.ID;
    }

    private void update() {
        if (this.mod) {
            double[] ins = ReadPair.estimateInsertSize(this.reads.values());
            this.mu = ins[0];
            this.sd = ins[1];
            this.nSd = Math.min(6, (int)Math.floor(this.mu / this.sd));
            this.mod = false;
        }
    }

    public double p(double ins) {
        double den = 2.0 * this.sd * this.sd;
        return Math.exp(-Math.pow(this.mu - ins, 2.0) / den) / Math.sqrt(Math.PI * den);
    }
}

