/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.halophiles.assembly.Contig;
import org.halophiles.tools.SummaryStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadPair {
    public static boolean INWARD;
    public static boolean OUTWARD;
    public final String hdr;
    public int pos1 = 0;
    public boolean rev1 = false;
    public int len1 = 0;
    public int qual1 = -1;
    public String cig1;
    public Contig ctg1;
    public int pos2 = 0;
    public boolean rev2 = false;
    public int len2 = 0;
    public String cig2;
    public Contig ctg2;
    public int qual2 = -1;
    public boolean paired;
    public boolean outward;
    public boolean inward;
    private boolean endSpanning;
    private int ins = -1;

    public ReadPair(String hdr) {
        this.hdr = hdr;
    }

    public String contigString() {
        return this.ctg1.name + "-" + this.ctg2.name;
    }

    public int addRead(int pos, boolean rev, int len, Contig ctg, int qual, String cig) {
        if (this.pos1 == 0) {
            this.pos1 = pos;
            this.rev1 = rev;
            this.len1 = len;
            this.ctg1 = ctg;
            this.cig1 = cig;
            this.qual1 = qual;
            this.paired = false;
            this.outward = false;
            this.inward = false;
            return 1;
        }
        if (this.pos2 == 0) {
            if (this.ctg1.getId() < ctg.getId()) {
                this.pos2 = pos;
                this.rev2 = rev;
                this.len2 = len;
                this.ctg2 = ctg;
                this.cig2 = cig;
                this.qual2 = qual;
            } else if (this.ctg1.getId() == ctg.getId()) {
                if (this.pos1 > pos) {
                    this.pos2 = this.pos1;
                    this.rev2 = this.rev1;
                    this.len2 = this.len1;
                    this.ctg2 = this.ctg1;
                    this.cig2 = this.cig1;
                    this.qual2 = this.qual1;
                    this.pos1 = pos;
                    this.rev1 = rev;
                    this.len1 = len;
                    this.ctg1 = ctg;
                    this.cig1 = cig;
                    this.qual1 = qual;
                } else {
                    this.pos2 = pos;
                    this.rev2 = rev;
                    this.len2 = len;
                    this.ctg2 = ctg;
                    this.cig2 = cig;
                    this.qual2 = qual;
                }
                this.outward = this.rev1 && !this.rev2;
                this.inward = !this.outward;
            } else {
                this.pos2 = this.pos1;
                this.rev2 = this.rev1;
                this.len2 = this.len1;
                this.ctg2 = this.ctg1;
                this.cig2 = this.cig1;
                this.qual2 = this.qual1;
                this.pos1 = pos;
                this.rev1 = rev;
                this.len1 = len;
                this.ctg1 = ctg;
                this.cig1 = cig;
                this.qual1 = qual;
            }
            this.paired = true;
            if (!this.ctg1.equals(this.ctg2)) {
                System.out.print("");
            }
            return 2;
        }
        return -1;
    }

    public void setEndSpanning(boolean endSpanning) {
        this.endSpanning = endSpanning;
    }

    public int getInsert() {
        if (this.ins > -1) {
            return this.ins;
        }
        if (this.ctg1 != null && this.ctg2 != null && this.ctg1.equals(this.ctg2)) {
            this.ins = this.endSpanning ? this.ctg1.len - this.pos2 + this.pos1 + this.len1 : this.pos2 - this.pos1 + this.len2;
            return this.ins;
        }
        return -1;
    }

    public int getQual() {
        if (this.pos1 == 0) {
            return -1;
        }
        if (this.pos2 == 0) {
            return this.qual1 % 255;
        }
        return (this.qual1 % 255 + this.qual2 % 255) / 2;
    }

    public String toString() {
        return this.hdr;
    }

    public static void exportInsertSize(Collection<ReadPair> reads, PrintStream out) {
        Iterator<ReadPair> it = reads.iterator();
        ReadPair tmp = null;
        while (it.hasNext()) {
            tmp = it.next();
            if (!tmp.paired || !tmp.ctg1.equals(tmp.ctg2)) continue;
            out.println(tmp.getInsert() + "\t" + (tmp.inward ? 1 : -1));
        }
    }

    public static double[] estimateInsertSize(Collection<ReadPair> reads) {
        Iterator<ReadPair> it = reads.iterator();
        ReadPair tmp = null;
        Vector<Double> vals = new Vector<Double>();
        while (it.hasNext()) {
            tmp = it.next();
            if (!tmp.paired || !tmp.ctg1.equals(tmp.ctg2)) continue;
            vals.add(new Double(tmp.getInsert()));
        }
        Object[] arD = vals.toArray(new Double[vals.size()]);
        Arrays.sort(arD);
        double[] dat = new double[arD.length];
        for (int i = 0; i < dat.length; ++i) {
            dat[i] = (Double)arD[i];
        }
        double mean = SummaryStats.mean(dat);
        double stdev = Math.sqrt(SummaryStats.variance(dat, mean));
        double[] ret = new double[]{Math.round(mean), Math.round(stdev), dat.length};
        return ret;
    }

    public static Map<String, ReadPair> filterTailPairs(Map<String, ReadPair> reads, double alpha) {
        int i;
        ReadPair[] ar = new ReadPair[reads.size()];
        reads.values().toArray(ar);
        Arrays.sort(ar, new /* Unavailable Anonymous Inner Class!! */);
        Vector<String> rm = new Vector<String>();
        int l = (int)(alpha / 2.0 * (double)ar.length);
        int r = (int)((1.0 - alpha / 2.0) * (double)ar.length);
        for (i = 0; i < l; ++i) {
            rm.add(ar[i].hdr);
        }
        for (i = r; i < ar.length; ++i) {
            rm.add(ar[i].hdr);
        }
        ReadPair.removeKeys(reads, rm);
        return reads;
    }

    public static double[] estimateInsertSizeIQR(Collection<ReadPair> reads) {
        Iterator<ReadPair> it = reads.iterator();
        ReadPair tmp = null;
        Vector<Double> vals = new Vector<Double>();
        while (it.hasNext()) {
            tmp = it.next();
            if (!tmp.paired || !tmp.ctg1.equals(tmp.ctg2)) continue;
            vals.add(new Double(tmp.getInsert()));
        }
        Object[] arD = vals.toArray(new Double[vals.size()]);
        Arrays.sort(arD);
        double[] dat = new double[arD.length * 8 / 10];
        int j = arD.length / 10;
        for (int i = 0; i < dat.length; ++i) {
            dat[i] = (Double)arD[j++];
        }
        double mean = SummaryStats.mean(dat);
        double stdev = Math.sqrt(SummaryStats.variance(dat, mean));
        double[] ret = new double[]{Math.round(mean), Math.round(stdev), dat.length};
        return ret;
    }

    public static Map<String, ReadPair> filterDiagReads(Map<String, ReadPair> reads, double[] ins, int nSd) {
        Iterator<String> it = reads.keySet().iterator();
        Vector<String> rm = new Vector<String>();
        String key = null;
        ReadPair r = null;
        while (it.hasNext()) {
            key = it.next();
            r = reads.get(key);
            if (!ReadPair.isDiag(r, ins, nSd)) continue;
            rm.add(key);
        }
        ReadPair.removeKeys(reads, rm);
        return reads;
    }

    public static Map<String, ReadPair> filterRange(Map<String, ReadPair> reads, double min, double max) {
        Iterator<String> it = reads.keySet().iterator();
        Vector<String> rm = new Vector<String>();
        String key = null;
        ReadPair r = null;
        double ins = 0.0;
        while (it.hasNext()) {
            key = it.next();
            r = reads.get(key);
            ins = r.getInsert();
            if (!(ins > min) || !(ins < max)) continue;
            rm.add(key);
        }
        ReadPair.removeKeys(reads, rm);
        return reads;
    }

    public static int getOrientation(Collection<ReadPair> reads) {
        Iterator<ReadPair> it = reads.iterator();
        double NIN = 0.0;
        double NOUT = 0.0;
        ReadPair tmp = null;
        while (it.hasNext()) {
            tmp = it.next();
            if (tmp.inward) {
                NIN += 1.0;
                continue;
            }
            if (!tmp.outward) continue;
            NOUT += 1.0;
        }
        if (NIN > NOUT) {
            return 0;
        }
        return 1;
    }

    private static boolean isDiag(ReadPair r, double[] ins, int nSd) {
        double dist = Math.abs(r.pos1 - r.pos2);
        return dist < ins[0] + (double)nSd * ins[1] && dist > ins[0] - (double)nSd * ins[1] && r.ctg1.equals(r.ctg2);
    }

    private static <V> void removeKeys(Map<String, V> reads, Collection<String> torm) {
        Iterator<String> it = torm.iterator();
        while (it.hasNext()) {
            reads.remove(it.next());
        }
    }
}

