/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.halophiles.assembly.ReadPair;
import org.halophiles.assembly.ReadSet;
import org.halophiles.assembly.SAMFileParser;
import org.halophiles.assembly.qc.EMClusterer;

public class InsertSizeExporter {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java GetInsertSize.jar <sam_file1> . . . <sam_fileN>");
            System.exit(-1);
        }
        NumberFormat NF = NumberFormat.getInstance();
        NF.setMaximumFractionDigits(0);
        NF.setGroupingUsed(false);
        try {
            for (int i = 0; i < args.length; ++i) {
                File samFile = new File(args[i]);
                System.err.println("[a5_ise] Getting insert stats for " + samFile.getAbsolutePath());
                SAMFileParser sfp = new SAMFileParser(samFile.getAbsolutePath());
                ReadPair tmp = null;
                HashMap<String, ReadPair> reads = new HashMap<String, ReadPair>();
                TreeSet<ReadPair> uniq = new TreeSet<ReadPair>(new Comparator<ReadPair>(){

                    @Override
                    public int compare(ReadPair arg0, ReadPair arg1) {
                        if (arg0.ctg1.equals(arg1.ctg1)) {
                            if (arg0.ctg2.equals(arg1.ctg2)) {
                                if (arg0.pos1 == arg1.pos1) {
                                    if (arg0.pos2 == arg1.pos2) {
                                        return 0;
                                    }
                                    return arg0.pos2 - arg1.pos2;
                                }
                                return arg0.pos1 - arg1.pos1;
                            }
                            return arg0.ctg2.compareTo(arg1.ctg2);
                        }
                        return arg0.ctg1.compareTo(arg1.ctg1);
                    }
                });
                Iterator<ReadPair> rpIt = sfp.getReadPairs();
                while (rpIt.hasNext()) {
                    tmp = rpIt.next();
                    if (!tmp.paired || !tmp.ctg1.equals(tmp.ctg2) || !uniq.add(tmp)) continue;
                    reads.put(tmp.hdr, tmp);
                }
                double[] insTot = ReadPair.estimateInsertSizeIQR(reads.values());
                double[] ret = new double[]{insTot[0], insTot[1], insTot[2], ReadPair.getOrientation(reads.values())};
                if (insTot[0] > 2000.0) {
                    System.err.println("[a5_ise] Average insert size > 2000. Assuming this is a mate-pair library");
                    System.err.println("[a5_ise] EM Clustering with K = 3 to remove noisy reads and shadow library");
                    EMClusterer em = new EMClusterer(reads.values(), 3);
                    em.iterate(1000, 1.0E-4);
                    Collection<ReadSet> emClusters = em.getClusters();
                    Iterator<ReadSet> clustIt = emClusters.iterator();
                    ReadSet tmpClust = null;
                    double lowV = 2.0E9;
                    ReadSet highC = null;
                    while (clustIt.hasNext()) {
                        tmpClust = clustIt.next();
                        System.err.println("Cluster mean " + tmpClust.mean() + " sd " + tmpClust.sd() + " size " + tmpClust.size());
                        if (!(tmpClust.mean() > 1500.0) || !(lowV > tmpClust.sd())) continue;
                        lowV = tmpClust.sd();
                        highC = tmpClust;
                    }
                    ret[0] = highC.mean();
                    ret[1] = highC.sd();
                    ret[2] = highC.size();
                    ret[3] = ReadPair.getOrientation(highC.getReads());
                }
                System.out.println(NF.format(ret[0]) + "," + NF.format(ret[1]) + "," + NF.format(ret[2]) + "," + NF.format(ret[3]));
                System.out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

