\name{intCNGEan.profilesPlot}
\alias{intCNGEan.profilesPlot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ CN-GE profiles plot }
\description{
Plots a sample's copy number and gene expression data side-by-side.
This visualizes the relation between CN and GE within an individual sample.
}
\usage{
intCNGEan.profilesPlot(CNdata, GEdata, sampleNo, chr = 0)
}
\arguments{
  \item{CNdata}{ Object of class \code{cghCall}, containing (among others) annotion and call probabilities. Features should be matched with those of the
accompanying \code{ExpressionSet}-object (as may be done using the \code{intCNGEan.match}-function).  }
  \item{GEdata}{ Object of class \code{ExpressionSet}. Features should be matched with those of the accompanying
\code{cghCall}-object (as may be done using the \code{intCNGEan.match}-function). }
  \item{sampleNo}{ Sample number of sample to be plotted. Corresponds to the order in which samples appear the \code{CNdata}- and \code{GEdata}-objects. }
  \item{chr}{ Chromosome number for which the profiles are to be plotted. Default \code{chr=0} for whole genome plotting. }
}
\details{
The blue lines in the gene expression profile plot are the median expressions of genes that map to the same copy number segment.
}
\references{ 
Van Wieringen, W.N., Van de Wiel, M.A. (2009), "Non-parametric testing for DNA copy number induced differential mRNA gene expression", 
\emph{Biometrics}, 65(1), 19-29. 
}
\author{ Wessel N. van Wieringen: \email{wvanwie@few.vu.nl} }
\seealso{ \code{intCNGEan.match}, \code{intCNGEan.tune}, \code{intCNGEan.test} }
\examples{
# load data
data(pollackCN)
data(pollackGE)

# match features from both platforms
CNGEdataMatched <- intCNGEan.match(pollackCN, pollackGE)

# plot CN and GE profiles alongside
intCNGEan.profilesPlot(CNGEdataMatched$CNdata.matched, CNGEdataMatched$GEdata.matched, 23)
}
