\name{intCNGEan.tune}
\alias{intCNGEan.tune}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Pre-test and tuning. }
\description{
Decides which test to perform: loss vs. no-loss (tumor surpressor) or no-gain vs gain (proto-onco).
Followed by a tuning algorithm that enhances the overal power of the FDR procedure by excluding genes
with either unbalanced (many samples having a high call probability of, say, a loss) or imprecise 
(many call probabilities close to 0.5) soft calls, which is likely to increase the probability of 
detection for genes with a more favorable call probability distribution.
}
\usage{
intCNGEan.tune(CNdata, GEdata, test.statistic, ngenetune = 250, nperm_tuning = 250, minCallProbMass = 0.05)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{CNdata}{ Object of class \code{cghCall}, containing (among others) annotion and call probabilities. Features should be matched with those of the
accompanying \code{ExpressionSet}-object (as may be done using the \code{intCNGEan.match}-function).  }
  \item{GEdata}{ Object of class \code{ExpressionSet}. Features should be matched with those of the accompanying
\code{cghCall}-object (as may be done using the \code{intCNGEan.match}-function). }
  \item{test.statistic}{ Test statistic to be used, either \code{"wcvm"} or \code{"wmw"}, the weighted Cramer-Von Mises and
the weighted Mann-Whitney test statistic, respectively. }
  \item{ngenetune}{ Number of genes used for tuning. }
  \item{nperm_tuning}{ Number of permutation used for tuning. }
  \item{minCallProbMass}{ A number inbetween 0 and 1. Genes with a marginal call probabilities in one of the classes smaller than \code{minCallProbMass}
are discarded from further analysis. Effectively, this ensures identifiability of copy number effect on expression.}
  \item{trace}{ Boolean to suppress output, either \code{FALSE} and \code{TRUE}. }
}
\details{
  ~~ If necessary, more details than the description above ~~
}
\value{
  A \code{list}-object with the following entries:
  \item{datafortest}{A \code{matrix} containing both copy number and gene expression data of genes selected for testing.}
  \item{lossorgain}{Indicator of test to be performed, either \code{"1"} (loss vs. no-loss) or \code{"2"} (no-gain vs. gain).}
  \item{genestotest}{Genes selected for testing. Numbering corresponds to genes of the pre-tuned, matched data set.}
  \item{callprobs}{Estimated marginal call probability distributions.}
  \item{alleffects}{Estimated copy number induced expression level changes.}
  \item{ann}{A \code{matrix} containing the annotation information of the genes selected for testing.}
  \item{nosamp}{Number of samples in the data set.}
}
\references{ 
Van Wieringen, W.N., Van de Wiel, M.A. (2009), "Non-parametric testing for DNA copy number 
induced differential mRNA gene expression", \emph{Biometrics}, 65(1), 19-29. 
}
\author{ Wessel N. van Wieringen: \email{wvanwie@few.vu.nl} }
\seealso{ \code{intCNGEan.match}, \code{intCNGEan.test} }
\examples{
# load data
data(pollackCN)
data(pollackGE)

# match features from both platforms
CNGEdataMatched <- intCNGEan.match(pollackCN, pollackGE)

# discard genes that are unlikely to become significant
CNGEdataTuned <- intCNGEan.tune(CNGEdataMatched$CNdata.matched, CNGEdataMatched$GEdata.matched, "wcvm")
}
