\name{intCNGEan.test}
\alias{intCNGEan.test}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Nonparametric testing for copy number induced differential gene expression. }
\description{
A nonparametric test for the detection of copy number induced differential gene expression. 
The test incorporates the uncertainty of the calling of genomic aberrations:
weighted version of well-known test statistics are used.
An efficient permutation re-sampling procedure is used for
p-value calculation.
The test statistics may be "shrunken" to borrow information across neighboring
genes that share the same copy number signature. 
}
\usage{
intCNGEan.test(data.tuned, analysis.type, test.statistic, nperm = 10000, eff.p.val.thres = 0.1)
}
\arguments{
  \item{data.tuned}{ A list object as returned by the \code{intCNGEan.tune}-function. }
  \item{analysis.type}{ Indicator to determine whether the test statistic should be "shrunken" within a region. Either \code{"univariate"} (no shrinkage) 
or \code{"regional"} (shrinkage).}
  \item{test.statistic}{ Test statistic to be used, either \code{"wcvm"} or \code{"wmw"}, the weighted Cramer-Von Mises and
the weighted Mann-Whitney test statistic, respectively. }
  \item{nperm}{ Number of permutations used for the p-value calculation. }
  \item{eff.p.val.thres}{ A value between 0 and 1. Determines speed of efficient p-value calculation. 
	Genes with a probability smaller than 0.001 of a p-value smaller than \code{eff.p.val.thres} are discarded from the permutation analysis and their p-value is set equal to 1. 
	Should be chosen in accordance with the FDR-threshold for significance. }
}
\details{
  ~~ If necessary, more details than the description above ~~
}
\value{
In case \code{analysis.type="univariate"} the function returns a \code{matrix} with the following columns: 
the first three columns contain the annotation information; the gene number of the
original (pre-tuned, matched) data set; indicator of test performed, either \code{"1"} (loss vs. no-loss) or \code{"2"} (no-gain vs. gain);
the estimated marginal call probability distribution (two columns); the estimated copy number induced gene expression change;
the coefficient of determination; the raw p-value; the BH-corrected p-value.

In case \code{analysis.type="regional"} the function returns a \code{matrix} with the following columns: 
the first three columns contain the annotation information; the gene number of the
original (pre-tuned, matched) data set; indicator of test performed, either \code{"1"} (loss vs. no-loss) or \code{"2"} (no-gain vs. gain);
the estimated marginal call probability distribution (two columns);  the estimated copy number induced gene expression change; 
the coefficient of determination; the region number within chromosome; gene number of first and last gene within the
region (two columns); shrinkage parameter; the raw p-value; the BH-corrected p-value.
}
\references{ 
Van Wieringen, W.N., Van de Wiel, M.A. (2009), "Non-parametric testing for DNA copy number induced differential
mRNA gene expression", \emph{Biometrics}, 65(1), 19-29. 
}
\author{ Wessel N. van Wieringen: \email{wvanwie@few.vu.nl} }
\seealso{ \code{intCNGEan.tune} }
\examples{
# load data
data(pollackCN)
data(pollackGE)

# match features from both platforms
CNGEdataMatched <- intCNGEan.match(pollackCN, pollackGE)

# discard genes that are unlikely to become significant
CNGEdataTuned <- intCNGEan.tune(CNGEdataMatched$CNdata.matched, CNGEdataMatched$GEdata.matched, "wcvm")

# nonparametrical testing
CNGEtestResults <- intCNGEan.test(CNGEdataTuned, "univariate", "wcvm", 100, 0.10)
}
