\name{intCNGEan.plot}
\alias{intCNGEan.plot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ DNA-mRNA plot }
\description{
A variant on the boxplot, plotting the gene expression against the
copy number data. For each individual an open blue circle per call is plotted, all with their centerpoint
at the height of the individual's expression level. The radius of the circles is proportional to the corresponding call
probabilities. Call probabilities equal to zero reduce circles to dots. The red filled circles have a radius proportional to the
estimated expected call probabilities, with their centerpoints at the estimated mean expression for the respective call.
}
\usage{
intCNGEan.plot(gene.id, data.tuned)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{gene.id}{ The number of the gene to be plotted. The gene number is to the position of the gene in the set of genes not removed in the tuning step. }
  \item{data.tuned}{ A \code{list}-object as returned by the \code{intCNGEan.tune}-function. }
}
\references{ 
Van Wieringen, W.N., Van de Wiel, M.A. (2009), "Non-parametric testing for DNA copy number 
induced differential mRNA gene expression", \emph{Biometrics}, 65(1), 19-29. 
}
\author{ Wessel N. van Wieringen: \email{wvanwie@few.vu.nl} }
\seealso{ \code{boxplot}, \code{intCNGEan.test}, \code{intCNGEan.tune} }
\examples{
# load data
data(pollackCN)
data(pollackGE)

# match features from both platforms
CNGEdataMatched <- intCNGEan.match(pollackCN, pollackGE)

# discard genes that are unlikely to become significant
CNGEdataTuned <- intCNGEan.tune(CNGEdataMatched$CNdata.matched, CNGEdataMatched$GEdata.matched, "wcvm")

# nonparametrical testing
CNGEtestResults <- intCNGEan.test(CNGEdataTuned, "univariate", "wcvm", 100, 0.10)

# plot copy number vs. gene expression.
intCNGEan.plot(1, CNGEdataTuned)
}
