intCNGEan.profilesPlot <-
function(CNdata, GEdata, sampleNo, chr=0){
################################################################################################
# function for plotting the copy number and gene expression profiles of an individual sample
################################################################################################

makeSegments <- function(data) {
previous    <- 2000
values      <- c()
start       <- c()
end         <- c()
for (i in 1:length(data)) {
if (data[i] != previous) {
start   <- c(start, i)
last    <- i - 1
if (last > 0) end <- c(end, last)
values  <- c(values, data[i])
        }
previous    <- data[i]
}
end     <- c(end, length(data))
result  <- cbind(values, start, end)
result
}

profilePlot <- function (x, segment, z){

calls           <- calls(x)
nsamples        <- ncol(x)
if (!is.null(probamp(x))){ nclass <- 4 } else { nclass <- 3 }
chrom           <- chromosomes(x)
chrom.labels    <- unique(chrom)
nclone          <- length(chrom)
i <- 1
    
genomdat        <- copynumber(x)[,1]
probsdraw       <- cbind(probloss(x)[,1], probnorm(x)[,1], probgain(x))
if (!is.null(probamp(x))){ probsdraw <- cbind(probsdraw, probamp(x)[,1]) }
lt              <- 0
        
widths          <- segment[,3] - segment[,2] + 1
plot.data       <- probsdraw[segment[,2],]
    
par(mar=c(5, 4, 4, 4) + 0.2)
        
### Plot the probability bars
if (z){ barplot(t(plot.data), width=widths, border=FALSE, space=0, col=c("#FF000033", "white", "#00FF0033"), las=1, cex.axis=1, cex.lab=1, xaxt="n")
} else { barplot(t(plot.data), width=widths, border=FALSE, space=0, col=c("red","white","green"), las=1, cex.axis=1, cex.lab=1, xaxt="n") }
        
lim <- par("usr")
if (z) { YaxisLimits <- c(floor(min(copynumber(x)[,1], na.rm=TRUE)), ceiling(max(copynumber(x)[,1], na.rm=TRUE))); lim[3:4] <- YaxisLimits
} else { lim[3:4] <- c(-5, 5)}
par(usr=lim)
if (z) { dticks <- seq(YaxisLimits[1], YaxisLimits[2], by=1)
} else { dticks <- seq(-5, 5, by=1)}
axis(4, at=dticks, labels=dticks, srt=270, las=1, cex.axis=1, cex.lab=1)
box()
        
### Add axis labels
if (z) { mtext("norm. GE", side=4, line=3, srt=270)
} else { mtext("norm. CN", side=4, line=3, srt=270) }
mtext("probability", side=2, line=3, srt=270)
        
#### add vert lines at chromosome ends
abline(h=0) 
if (z) { for (iii in 1:length(cumsum(table(chrom)))) { segments(cumsum(table(chrom))[[iii]], YaxisLimits[1], cumsum(table(chrom))[[iii]], YaxisLimits[2], lty=2) } 
} else { for (iii in 1:length(cumsum(table(chrom)))) { segments(cumsum(table(chrom))[[iii]], -5, cumsum(table(chrom))[[iii]], 5, lty=2) }}

if (z) { title(paste("GE profile:", sampleNames(x)[1], sep=" "))
} else { title(paste("CN profile:", sampleNames(x)[1], sep=" ")) }

        ### Add log2ratios
points((1:nclone)-.5,genomdat,cex=.1)
        
### X-axis with chromosome labels
ax <- (cumsum(table(chrom))+c(0, cumsum(table(chrom))[-length(cumsum(table(chrom)))]))/2
axis(side=1, at=ax, labels=chrom.labels, cex=.2, lwd=.5, las=1, cex.axis=1, cex.lab=1) # bottom axis
            
### Blue lines for segment means
if (z) { for (jjj in (1:nrow(segment))){ segments(segment[jjj,2], segment[jjj,1], segment[jjj,3], segment[jjj,1], col="blue", lwd=3) }
} else { for (jjj in (1:nrow(segment))){ segments(segment[jjj,2], segment[jjj,1], segment[jjj,3], segment[jjj,1], col="blue", lwd=3) } }
}

# input checks
if (dim(fData(CNdata))[1] != dim(fData(GEdata))[1]){ stop("CN and GE data have different number of rows.") }
if (!all(fData(CNdata)[,1] == fData(GEdata)[,1])){ stop("chrosome annotation between CN and GE does not match.") }

# filter data corresponding to chromosome 
if (chr != 0){
ids <- which(fData(CNdata)[,1] == chr)
if (length(ids) == 0){ stop("supplied chromosome does not exist.") }
fData(CNdata) <- fData(CNdata)[ids, , drop=FALSE]
copynumber(CNdata) <- copynumber(CNdata)[ids, , drop=FALSE]
segmented(CNdata) <- segmented(CNdata)[ids, , drop=FALSE]
probloss(CNdata) <- probloss(CNdata)[ids, , drop=FALSE]
probnorm(CNdata) <- probnorm(CNdata)[ids, , drop=FALSE]
probgain(CNdata) <- probgain(CNdata)[ids, , drop=FALSE]
calls(CNdata) <- calls(CNdata)[ids, , drop=FALSE]
fData(GEdata) <- fData(GEdata)[ids, , drop=FALSE]
exprs(GEdata) <- exprs(GEdata)[ids, , drop=FALSE]
}

# calculate median expression per segment
SegExpr <- numeric()
SegData <- segmented(CNdata[,sampleNo])
segmentsCN <- makeSegments(segmented(CNdata[,sampleNo]))
segmentsGE <- segmentsCN
for (j in 1:dim(segmentsCN)[1]){
ids <- c(segmentsCN[j,2]:segmentsCN[j,3])
medSegExpr <- median(exprs(GEdata)[ids, sampleNo])
segmentsGE[j, 1] <- medSegExpr
SegExpr <- c(SegExpr, rep(medSegExpr, length(ids)))
}

# modify CGHcall object
CNdataGE <- CNdata
segmented(CNdataGE)[,sampleNo] <- SegExpr
copynumber(CNdataGE)[,sampleNo] <- exprs(GEdata)[,sampleNo]

# plot profiles
op <- par(mfrow = c(2, 1), pty = "m")
profilePlot(CNdataGE[,sampleNo], segment=segmentsGE, z=TRUE)
profilePlot(CNdata[,sampleNo], segment=segmentsCN, z=FALSE)
par(op)
return(invisible(NULL))
}

