intCNGEan.plot <-
function (gene.id, data.tuned){
################################################################################################
# plot expression vs. copy number
################################################################################################

alphabivariate <- function(cgh.em, nosamp, a) {
################################################################################################
# function that calculated the second order moments of the call probabilities.
################################################################################################
        cgh.em <- matrix(cgh.em[c(1:(a * nosamp))], ncol = a, byrow = TRUE)
cgh.em1 <- cgh.em[, 1]
cgh.em2 <- cgh.em[, 2]
return(c(1/nosamp * (cgh.em1 %*% cgh.em1), 1/nosamp *  (cgh.em2 %*% cgh.em2), 1/nosamp * (cgh.em1 %*% cgh.em2)))
    }
alphaest <- function(cgh.em, nosamp, a) {
################################################################################################
# function that calculated the first order moments of the call probabilities.
################################################################################################
cgh.em <- matrix(cgh.em[c(1:(a * nosamp))], ncol = a, byrow = TRUE)
return(apply(cgh.em, 2, mean))
}
gene.id <- which(data.tuned$genestotest==gene.id)
cgh.em <- data.tuned$datafortest[gene.id, ]
alphasbiv <- alphabivariate(cgh.em[c(1:(2 * data.tuned$nosamp))], data.tuned$nosamp, 2)
alphas <- alphaest(cgh.em[c(1:(2 * data.tuned$nosamp))], data.tuned$nosamp, 2)
cgh.em <- cbind(matrix(cgh.em[c(1:(2 * data.tuned$nosamp))], ncol = 2, byrow = TRUE), cgh.em[c((2 * data.tuned$nosamp + 1):((2 + 1) * data.tuned$nosamp))])
c1 <- (alphasbiv[1]/alphasbiv[3] - alphas[1]/alphas[2])^(-1)
c2 <- (alphasbiv[2]/alphasbiv[3] - alphas[2]/alphas[1])^(-1)
mu1 <- (1/data.tuned$nosamp) * sum(cgh.em[, 3] * (cgh.em[,1] * alphas[2] - alphasbiv[3])/(alphasbiv[1] * alphas[2] - alphas[1] * alphasbiv[3]))
mu2 <- (1/data.tuned$nosamp) * sum(cgh.em[, 3] * (cgh.em[,2] * alphas[1] - alphasbiv[3])/(alphasbiv[2] * alphas[1] - alphas[2] * alphasbiv[3]))
overall.data <- cbind(c(1:2), cbind(alphas, c(mu1, mu2)))
clone.data <- cbind(rep(c(1:2), data.tuned$nosamp), data.tuned$datafortest[gene.id, c(1:(2 * data.tuned$nosamp))], as.numeric(t(matrix(rep(data.tuned$datafortest[gene.id, c((2 * data.tuned$nosamp + 1):((2 + 1) * data.tuned$nosamp))], 2), nrow = data.tuned$nosamp))))
    
symbols(overall.data[, 1], overall.data[, 3], circles = overall.data[, 2]/3, fg = "red", bg = "indianred1", ylim = c(min(clone.data[, 
        3]) - 3/4, max(clone.data[, 3]) + 3/4), xlim = c(1/2, 2 + 1/2), ylab = "gene expression", xlab = "DNA copy number", xaxt = "n", inches = FALSE, lwd = 3, main = rownames(data.tuned$datafortest)[gene.id])
    if (data.tuned$lossorgain[gene.id] == 1) {
        axis(1, at = c(1:2), labels = c("loss", "no-loss"))
} else {
        axis(1, at = c(1:2), labels = c("no-gain", "gain"))
}
symbols(clone.data[, 1], clone.data[, 3], circles = clone.data[,2]/3, fg = "blue", add = TRUE, inches = FALSE)
return(invisible(NULL))
}

