### R code from vignette source 'QDNAseq.Rnw'

###################################################
### code chunk number 1: QDNAseq.Rnw:22-23
###################################################
library(QDNAseq)


###################################################
### code chunk number 2: QDNAseq.Rnw:26-28
###################################################
options("QDNAseq::verbose"=NA)
options(width=40)


###################################################
### code chunk number 3: QDNAseq.Rnw:65-77 (eval = FALSE)
###################################################
## readCounts <- binReadCounts(bins)
## # all files ending in .bam from the current working directory
## 
## # or
## 
## readCounts <- binReadCounts(bins, bamfiles='tumor.bam')
## # file 'tumor.bam' from the current working directory
## 
## # or
## 
## readCounts <- binReadCounts(bins, path='tumors')
## # all files ending in .bam from the subdirectory 'tumors'


###################################################
### code chunk number 4: QDNAseq.Rnw:88-91
###################################################
data(LGG150)
readCounts <- LGG150
readCounts


###################################################
### code chunk number 5: rawprofile
###################################################
plot(readCounts, logTransform=FALSE, ylim=c(-50, 200))
highlightFilters(readCounts, logTransform=FALSE,
  residual=TRUE, blacklist=TRUE)


###################################################
### code chunk number 6: QDNAseq.Rnw:105-106
###################################################
plot(readCounts, logTransform=FALSE, ylim=c(-50, 200))
highlightFilters(readCounts, logTransform=FALSE,
  residual=TRUE, blacklist=TRUE)


###################################################
### code chunk number 7: QDNAseq.Rnw:118-120
###################################################
readCountsFiltered <- applyFilters(readCounts,
  residual=TRUE, blacklist=TRUE)


###################################################
### code chunk number 8: isobar
###################################################
isobarPlot(readCountsFiltered)


###################################################
### code chunk number 9: QDNAseq.Rnw:128-129
###################################################
isobarPlot(readCountsFiltered)


###################################################
### code chunk number 10: QDNAseq.Rnw:143-144
###################################################
readCountsFiltered <- estimateCorrection(readCountsFiltered)


###################################################
### code chunk number 11: noise
###################################################
noisePlot(readCountsFiltered)


###################################################
### code chunk number 12: QDNAseq.Rnw:152-153
###################################################
noisePlot(readCountsFiltered)


###################################################
### code chunk number 13: QDNAseq.Rnw:163-167
###################################################
copyNumbers <- correctBins(readCountsFiltered)
copyNumbers
copyNumbersNormalized <- normalizeBins(copyNumbers)
copyNumbersSmooth <- smoothOutlierBins(copyNumbersNormalized)


###################################################
### code chunk number 14: profile
###################################################
plot(copyNumbersSmooth)


###################################################
### code chunk number 15: QDNAseq.Rnw:175-176
###################################################
plot(copyNumbersSmooth)


###################################################
### code chunk number 16: QDNAseq.Rnw:189-191
###################################################
copyNumbersSegmented <- segmentBins(copyNumbersSmooth)
copyNumbersSegmented <- normalizeSegmentedBins(copyNumbersSegmented)


###################################################
### code chunk number 17: segments
###################################################
plot(copyNumbersSegmented)


###################################################
### code chunk number 18: QDNAseq.Rnw:199-200
###################################################
plot(copyNumbersSegmented)


###################################################
### code chunk number 19: QDNAseq.Rnw:209-210
###################################################
copyNumbersCalled <- callBins(copyNumbersSegmented)


###################################################
### code chunk number 20: calls
###################################################
plot(copyNumbersCalled)


###################################################
### code chunk number 21: QDNAseq.Rnw:218-219
###################################################
plot(copyNumbersCalled)


###################################################
### code chunk number 22: QDNAseq.Rnw:228-230
###################################################
cgh <- makeCgh(copyNumbersCalled)
cgh


###################################################
### code chunk number 23: QDNAseq.Rnw:256-266 (eval = FALSE)
###################################################
## # load required packages for human reference genome build hg19
## library(QDNAseq)
## library(Biobase)
## library(BSgenome.Hsapiens.UCSC.hg19)
## 
## # set the bin size
## binSize <- 15
## 
## # create bins from the reference genome
## bins <- createBins(bsgenome=BSgenome.Hsapiens.UCSC.hg19, binSize=binSize)


###################################################
### code chunk number 24: QDNAseq.Rnw:283-287 (eval = FALSE)
###################################################
## # calculate mappabilites per bin from ENCODE mapability tracks
## bins$mappability <- calculateMappability(bins,
##   bigWigFile='/path/to/wgEncodeCrgMapabilityAlign50mer.bigWig',
##   bigWigAverageOverBed='/path/to/bigWigAverageOverBed')


###################################################
### code chunk number 25: QDNAseq.Rnw:299-303 (eval = FALSE)
###################################################
## # calculate overlap with ENCODE blacklisted regions
## bins$blacklist <- calculateBlacklist(bins,
##   bedFiles=c('/path/to/wgEncodeDacMapabilityConsensusExcludable.bed',
##   '/path/to/wgEncodeDukeMapabilityRegionsExcludable.bed'))


###################################################
### code chunk number 26: QDNAseq.Rnw:308-314 (eval = FALSE)
###################################################
## # load data for the 1000 Genomes (or similar) data set, and generate residuals
## tg <- binReadCounts(bins,
##   path='/path/to/1000Genomes/bam/files')
## tg <- applyFilters(tg, residual=FALSE, blacklist=FALSE,
##   mappability=FALSE, bases=FALSE)
## bins$residual <- iterateResiduals(tg)


###################################################
### code chunk number 27: QDNAseq.Rnw:323-326 (eval = FALSE)
###################################################
## # by default, use all autosomal bins that have a reference sequence
## # (i.e. not only N's)
## bins$use <- bins$chromosome %in% as.character(1:22) & bins$bases > 0


###################################################
### code chunk number 28: QDNAseq.Rnw:332-345 (eval = FALSE)
###################################################
## # convert to AnnotatedDataFrame and add metadata
## bins <- AnnotatedDataFrame(bins,
##   varMetadata=data.frame(labelDescription=c(
##   'Chromosome name',
##   'Base pair start position',
##   'Base pair end position',
##   'Percentage of non-N nucleotides (of full bin size)',
##   'Percentage of C and G nucleotides (of non-N nucleotides)',
##   'Average mappability of 50mers with a maximum of 2 mismatches',
##   'Percent overlap with ENCODE blacklisted regions',
##   'Median loess residual from 1000 Genomes (50mers)',
##   'Whether the bin should be used in subsequent analysis steps'),
##   row.names=colnames(bins)))


###################################################
### code chunk number 29: QDNAseq.Rnw:351-362 (eval = FALSE)
###################################################
## attr(bins, "QDNAseq") <- list(
##   author="Ilari Scheinin",
##   date=Sys.time(),
##   organism="Hsapiens",
##   build="hg19",
##   version=packageVersion("QDNAseq"),
##   url=paste0(
##   "http://cdn.bitbucket.org/ccagc/qdnaseq/downloads/QDNAseq.hg19.",
##   binsize, "kbp.SR50.rds"),
##   md5=digest::digest(bins@data),
##   sessionInfo=sessionInfo())


###################################################
### code chunk number 30: QDNAseq.Rnw:369-370
###################################################
sessionInfo()


