\name{plotboth}
\alias{plotboth}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Plots wave corrected and uncorrected tumor profile in one plot}
\description{Plots wave corrected and uncorrected tumor profile in one plot or plots corrected profile alone}
\usage{
plotboth(samp = 1, CGHTumor, corrected, startchr = 1, endchr = 23, 
ylimit = 2, usesamplenames = TRUE, plot2=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{samp}{Tumor sample number, i.e. plot the \code{samp}th profile as appearing in the data file. }
  \item{CGHTumor}{Matrix containing 3 or 4 probe information columns, followed by the raw log2-ratio data for each tumor profile }
  \item{corrected}{Matrix containing 3 or 4 probe information columns, followed by the corrected log2-ratio data for each tumor profile }
  \item{startchr}{Start plotting from chromosome \code{startchr}. }
  \item{endchr}{Finish plotting at chromosome \code{endchr}. }
  \item{ylimit}{Plotting range around the median for the y-axis.}
  \item{usesamplenames}{Use FALSE when preferring sample numbers rather than sample names (TRUE) }
  \item{plot2}{Use FALSE when only the corrected tumor profiles should be plotted}
}

\value{
A graph showing the corrected tumor profile, possibly together with the uncorrected one.
}
\author{Mark van de Wiel}

\examples{
data(pdatatum)
data(pdatanormsmooth)
corrected <- CorrectTumors(pdatatum,pdatanormsmooth)
plotboth(samp=1,pdatatum,corrected)

\dontrun{
exportfilename <- "Uncor_vs_Cor.ps"
postscript("Uncor_vs_Cor.ps",onefile=T)
for(i in 1:ntum){
plotboth(samp=i,pdatatum,corrected)
}
dev.off()
}


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{aplot}
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
