\name{CorrectTumors}
\alias{CorrectTumors}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Removes wave bias from aCGH tumor profiles}
\description{
CorrectTumors removes wave bias from aCGH tumor profiles by applying ridge regression 
on smoothed calibration ("normal") profiles. 
}
\usage{
CorrectTumors(CGHTumor, CGHNormalSmooth, bandwidth = 1, thr = 2.5,
applyridgereg = TRUE, normalization = "none")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{CGHTumor}{Matrix containing 3 or 4 probe information columns, followed by log2-ratio data for each tumor profile}
  \item{CGHNormalSmooth}{Matrix containing 3 or 4 probe information columns, followed by the SMOOTHED log2-ratio data for each calibration profile}
  \item{bandwidth}{Bandwidth in MegaBase for computing moving averages for tumor profiles}
  \item{thr}{Threshold for non-inclusion of tumor probes in the regression. When the moving average exceeds \code{thr} times 
  the standard deviation, the probe is not used for fitting the regression model (note: it is not removed from the data).}
  \item{applyridgereg}{If \code{applyridgereg} = FALSE, slightly faster ordinary regression is used.}
  \item{normalization}{Normalization method. Either "none", "mode" or "median".}
} \details{The calibration profiles and tumor profiles may 
contain different probes as long as the overlap is dense with 
respect to the genome. When the probe sets are not the same, 
these are first matched to allow for regression. The correction 
for tumor probes absent in the calibration probes set is 
obtained by interpolating the correction for neighboring 
probes. Imputation (impute.knn) is automatically applied when missings are detected.  
The effect of wave correction 
may be best visible after segmentation} 

\value{Matrix of the same dimensions as the input CGHTumor 
matrix containing the de-waved tumor probe values} 

\references{van de Wiel MA, Brosens R, Eilers PHC, Kumps C, 
Meijer GA, Menten B, Sistermans E, Speleman F, Timmerman ME, 
Ylstra B (2009). Smoothing waves in array CGH tumor profiles. 
Bioinformatics. doi: 10.1093/bioinformatics/btp132.} 
\author{Mark van de Wiel} 
\examples{ 
data(pdatatum) 
data(pdatanormsmooth) 
corrected <- CorrectTumors(pdatatum,pdatanormsmooth) 
}
\keyword{smooth} 
