`plotboth` <-
function(samp=1,CGHTumor,corrected, startchr=1,endchr=23,ylimit=2,usesamplenames=TRUE,plot2=TRUE){
    #startchr <- 11;endchr<- 17 #startchr = start chromosome for plotting; endchr = last chromosome for plotting (max 23). Allows for zooming in.
    #ylimit <- 2  #ylimit is the range around the median for the y-axis
    #usesamplenames <- TRUE #set to TRUE when sample names should be used to denote the profiles
    #usesamplenames <- FALSE #set to FALSE when numbers should be used to denote the profiles  
    if(usesamplenames){profname <- colnames(CGHTumor)} else {profname <- 1:ncol(CGHTumor)}
    if(mean(CGHTumor[,4],na.rm = TRUE) > 100000) {t_end <- 4} else {t_end <- 3}
    whno24 <- which(CGHTumor[,2]<=23)
    CGHTumor <- CGHTumor[whno24,]
    chrs <- CGHTumor[,2]
    CGHTumor <- CGHTumor[,-(1:t_end),drop=FALSE]
    if(mean(corrected[,4],na.rm = TRUE) > 100000) {c_end <- 4} else {c_end <- 3}
    corrected <- corrected[,-(1:c_end),drop=FALSE]
    
    plotfunc_chr <- function(lrtrmean,st,end,chrom,yli = 2,delta=0,NameP="noName",wanttitle=TRUE,color="black") #delta allows for different -/+ ylimit
    {
    #lrtrmean=CGHTumor[,1];st=startchr;end=endchr;chrom=chrs;yli=ylimit;delta=0;NameP=paste("Uncorrected profile",profname[1]);wanttitle=TRUE;color="black"
    med <- median(lrtrmean)
    wh <- which(chrom>=st & chrom<=end)
    lrtrmean <- lrtrmean[wh]
    chrom <- chrom[wh]
    chrom.labels <- as.character(st:end)
    len<-length(lrtrmean)
    ax<-(cumsum(table(chrom))+c(0,cumsum(table(chrom))[-length(cumsum(table(chrom)))]))/2
    plot(1:len,lrtrmean,axes=FALSE,xlab="Position",ylim=c(med-yli,med+yli+delta),ylab="Log2ratio",cex=0.1,col=color)
    axis(side=1,at=ax,labels=chrom.labels,cex=.2,lwd=.5,las=1.5,cex.axis=1,cex.lab=1) # bottom axis
    dticks <- seq(-2,2,by=0.5)
    axis(side=2,at=dticks,labels=dticks,srt=270,las=1,cex.axis=1,cex.lab=1)  # right axis, log2ratio values
    box()
    if(wanttitle){
    titwidth <- NameP
    title(main=titwidth)
    }
    #### add vert lines at chromosome ends
    abline(v=cumsum(table(chrom)),lty=2) 
    for (iii in 1:length(cumsum(table(chrom)))) {
        segments(cumsum(table(chrom))[[iii]],-5,cumsum(table(chrom))[[iii]],5,lty=2)
    }
    }
    
    if(plot2){
        par(mfrow = c(2, 1),mar=c(2,2,2,2))
        plotfunc_chr(CGHTumor[,samp],st=startchr,end=endchr,chrs,yli=ylimit,NameP=paste("Uncorrected profile",profname[samp]))
        plotfunc_chr(corrected[,samp],st=startchr,end=endchr,chrs,yli=ylimit,NameP=paste("Corrected profile",profname[samp]))
    } else {
        plotfunc_chr(corrected[,samp],st=startchr,end=endchr,chrs,yli=ylimit,NameP=paste("Corrected profile",profname[samp]))
    }
}
