\name{doCompleteDEUAnalysis}
\alias{doCompleteDEUAnalysis}
\title{Perform complete differential exon usage analysis}
\description{
 This function performs a complete differential exon usage analysis, calling
 all the necessary functions and returning an \code{ExonCountSet} object 
 with p values, adjusted p values and fold change estimates.
}
\usage{
doCompleteDEUAnalysis( ecs, 
     formula0 = ~ sample + exon, 
     formula1 = ~ sample + exon + condition:exon, 
     minCount = 10,
     nCores = 1, 
     path = NULL, 
     FDR = 0.1, 
     fitExpToVar = "condition", 
     color = NULL, 
     color.samples = NULL ) 
}
\arguments{
\item{ecs}{
    An ExonCountSet object.
}
\item{formula0}{
   Formula for the reduced (null) model, to be passed to \code{\link{testForDEU}}; see there for details.
}
\item{formula1}{
   Formula for the full model, to be passed to \code{\link{estimateDispersions}} and \code{\link{testForDEU}}; see there for details.
}
\item{minCount}{
   Exons with less than `minCount' reads (summed over all samples) are
   excluded from the test. See \code{\link{estimateDispersions}} for details.
}   
\item{nCores}{
    Number of CPU cores to be used when running \code{\link{estimateDispersions}} and \code{\link{testForDEU}}.
    Load the ``parallel'' package beforehands if you want to use more than one core.
 }
\item{path}{
    A file system path to the directory into which the HTML report generated by
    \code{\link{DEXSeqHTML}} shoudl be written. If NULL, no report will be created.
 }
 \item{FDR}{
    Argument passed on to \code{\link{DEXSeqHTML}}; see there for details.
 }
\item{fitExpToVar}{
    Argument passed on to \code{\link{DEXSeqHTML}}; see there for details.
 }
 \item{color}{
    Argument passed on to \code{\link{DEXSeqHTML}}; see there for details.
 }
 \item{color.samples}{
    Argument passed on to \code{\link{DEXSeqHTML}}; see there for details.
 }
}
\value{
An object of class ExonCountSet.
}
\examples{
data("pasillaExons", package="pasilla")
pasillaExons <- doCompleteDEUAnalysis( pasillaExons, 
   formula0 = ~ sample + type * exon, 
   formula1 = ~ sample + type * exon + condition * exon )
   }

