\name{read.HTSeqCounts}
     \alias{read.HTSeqCounts}
     \title{Read counts output from HTSeq script.}
     \description{
       This function reads the output files from the HTSeq python scripts dexseq_prepare_annotation.py and dexseq_count.py 
       and gives back an ExonCountSet object.
     }
     \usage{
read.HTSeqCounts(countfiles, design, flattenedfile=NULL)
     }
     \arguments{
       \item{countfiles}{
          A string vector containing the output files with the paths from dexseq_count.py.
       }
       \item{design}{
          A vector of factors with information corresponding to each of the countfiles or 
          a data frame design (each column with a factor and each row with its respective 
          sample. If strings are given, they will be converted to factors.
       }
       \item{flattenedfile}{
          An flattened annotation gtf file generated by dexseq_prepare_annotation.py. 
          It is necessary for the visualization of the data but not required to test 
          for alternative exon usage.
       }
     }
     \value{
	An ExonCount object.
     }
     \examples{
library(DEXSeq)
inDir = system.file("extdata", package="pasilla", mustWork=TRUE)
annotationfile = file.path(inDir, "Dmel.BDGP5.25.62.DEXSeq.chr.gff")
samples = data.frame(
   condition = c(rep("treated", 3), rep("untreated", 4)),
   replicate = c(1:3, 1:4),
   row.names = dir(system.file("extdata", package="pasilla", mustWork=TRUE), 
       pattern="fb.txt"),
   stringsAsFactors = TRUE,
   check.names = FALSE
)

annotationfile = file.path(inDir, "Dmel.BDGP5.25.62.DEXSeq.chr.gff")

\dontrun{
   ecs = read.HTSeqCounts(countfiles = file.path(inDir, rownames(samples)), 
      design = samples, 
      flattenedfile = annotationfile)
       }
   }
\keyword{ExonCountSet}
