\name{miRBase2df.fun}
\alias{miRBase2df.fun}
\title{ Create a data frame of the links between transcripts and miRNAs }
\description{
One of the 7 functions prepares the required data objects of the CORNA package.
Based on the miRBase predictions, it creates a data frame representing the links between miRNAs and their target transcripts.
}
\usage{
miRBase2df.fun(file=NULL, url="ftp://ftp.sanger.ac.uk/pub/mirbase/targets/v5/arch.v5.txt.mus_musculus.zip",
               col.old=c("TRANSCRIPT_ID", "SEQ"), col.new=c("tran", "mir"))
}

\arguments{
  \item{file}{ A local file downloaded from miRBase. }
  \item{url}{ A web address of miRBase.  }
  \item{slim}{ Logical, if TRUE (default), the result data frame will have just have two columns "tran" and "mir"; 
  if FALSE, the full table will be returned so that further manipulation can be done. }
  \item{col.old}{ A character vector of columns you want to extract from the original table as transcript and miRNA. }
  \item{col.new}{ A character vector of columns names you want to have in the result.}
}
\value{
A data frame, first column is "tran" and second column is "mir" so every row represents a link between one transcript and one miRNA.
If "slim=FASLE", the whole table with the original column names will be returned.  
}

\author{
Xikun Wu and Michael Watson
}
\seealso{ BioMart2df.fun, GEO2df.fun, GO2df.fun, KEGG2df.fun, microRNA.org2df.fun, sam.probe.fun }
\examples{
# they are equivalent  
tran2mir.df <- miRBase2df.fun(file="v5.txt.mus_musculus")
tran2mir.df <- miRBase2df.fun(file="arch.v5.txt.mus_musculus.zip")
tran2mir.df <- miRBase2df.fun(url="ftp://ftp.sanger.ac.uk/pub/mirbase/targets/v5/arch.v5.txt.mus_musculus.zip")
}
\keyword{ manip }
