\name{corna.sub.fun}
\alias{corna.sub.fun}

\title{ Get a subset of a microarray data frame }
\description{
Get a subset of a microarray data frame which only contains data of some probes.
}
\usage{
corna.sub.fun(x, y)
}

\arguments{
  \item{x}{ Data frame of microarray results.}
  \item{y}{ A character vector of probes IDs. }
}

\value{
Data frame of a subset of the microarray results.
}


\author{
Xikun Wu and Michael Watson
}

\seealso{ microarray.df }
\examples{

x <- microarray.df
y <- c("1415670_at", "1415671_at", "1415672_at", "1415673_at")
corna.sub.fun(x, y)
#            GSM176756 GSM176757 GSM176758 GSM176759 GSM176760 GSM176761
# 1415670_at  8.288578  8.292615  8.302877  8.401299  8.484824  8.496253
# 1415671_at  9.421823  9.355831  9.551866  9.534381  9.661779  9.617030
# 1415672_at  9.735202  9.504242  9.810003  9.748532  9.875438  9.842889
# 1415673_at  5.938050  5.964681  6.298389  6.329506  6.519873  6.374867
}
\keyword{ manip }

