\name{corna.line.fun}
\alias{corna.line.fun}

\title{ Draw lines for probes in microarray data}
\description{
One of the two plotting functions of the CORNA package. Given a data frame of microarray, one line will be drawed for each probe. 
The x coordinate of the point in the plot corresponds to a particular array and the y coordinate is its value in that array. 
}
\usage{
corna.line.fun(x, scale.data=T, array.order=c(1:ncol(x)), probe.colour=NULL,  
               array.line=T, array.colour=rep("black", length(array.order)),
               las=1, ps=13, mar=c(7,3,3,1), type="l", xlab="", ylab="", asp="", main="CORNA lines", sub="",
               my.axis.1=axis(1, at=0:(n-1), lab=colnames(d), adj=0.5, cex.axis=0.8, col="black", tick=T),
               my.axis.2=axis(2, at=0:0, lab=0, adj=0, cex.axis=1, col="black", tick=T),
               my.axis.3="",
               my.axis.4="")}

\arguments{
  \item{x}{ Data frame of microarray data. }
  \item{array.order}{ Character vector of array as their order in the plot, default is the original order in x. }
  \item{array.line}{ Logical, if TRUE (default), a vertical line will be drawn for each array; if FALSE, not drawn. }
  \item{array.colour}{ Character vector of colours correspond to the array lines, default is all black. }
  \item{probe.colour}{ Character vector of colours correspond to the probes lines, default is rainbow colours. }
  \item{scale.data}{ Logical, if TRUE (default), the microarray data frame will be scaled; if FLASE, not sclaed. }
  \item{las}{ The las arguments pf par(), default is 1. }
  \item{ps}{ The ps arguments pf par(), default is 13. }
  \item{mar}{ The mar arguments pf par(), default is "c(7,3,3,1)". }
  \item{type}{ Type of the probes lines, default is "l". }
  \item{xlab}{ Title of the x axis, default is none. }
  \item{ylab}{ Title of the y axis, default is none. }
  \item{asp}{ The y/x aspect ratio, default is none. }
  \item{main}{ Overall title for the plot, default is "CORNA lines". }
  \item{sub}{ Sub title for the plot, default is none. }
  \item{my.axis.1}{ String to be used as the arguments for the below axis, default is 
  "axis(1, at=0:(n-1), lab=colnames(d), adj=0.5, cex.axis=0.8, col="black", tick=T)". }
  \item{my.axis.2}{ String to be used as the arguments for the left axis, default is 
  "axis(2, at=0:0, lab=0, adj=0, cex.axis=1, col="black", tick=T)". }
  \item{my.axis.3}{ String to be used as the arguments for the above axis, default is none. }
  \item{my.axis.4}{ String to be used as the arguments for the right axis, default is none. }
}

\author{
Xikun Wu and Michael Watson
}

\seealso{ corna.barplot.fun, scale, par, plot, lines, axis}
\examples{
corna.line.fun(x=microarray.df[1:9, ])

corna.line.fun(x=microarray.df[1:9, ],
               array.order= c("GSM176756", "GSM176758", "GSM176759", "GSM176757", "GSM176760", "GSM176761"), 
               array.colour=c("red",       "yellow",    "blue",      "green",     "purple",    "orange"),
               probe.colour=c("black", "green", "red", "yellow", "blue", "red", "yellow", "blue", "red"),
               type="b",
               las=0, ps=11, mar=c(7,3,3,1),
               main="corna lines with more setting",
               sub="test more settings")            

}

\keyword{ hplot }