\name{corna.barplot.fun}
\alias{corna.barplot.fun}

\title{ Draw barplots for each probes in microarray data }
\description{
One of the two plotting functions of the CORNA package. Given a data frame of microarray, one barplot will be drawn 
for each probe and they compose a sinlge plot of barplots. In the individual barplot, the x coordinate corresponds 
to array and the y coordinate is its value in that array. 
}

\usage{
corna.barplot.fun(x, scale.data=TRUE, row=1, column=1, 
                  array.order=c(1:ncol(x)), 
                  array.colour=rainbow(length(array.order)), 
                  probe.colour=rep("black", nrow(x)), 
                  las=1, ps=8, mar=c(1.5,3,2.5,1), 
                  main="CORNA barplots", sub="", xlab="", ylab="", line=NA, outer=F)
}

\arguments{
  \item{x}{ Data frame of microarray data. }
  \item{scale.data}{ Logical, if TRUE (default), the microarray data frame will be scaled; if FLASE, not sclaed. }
  \item{row}{ Number of rows of the barplots in the plot, default is 1. }
  \item{column}{ Number of columns of the barplots in the plot, default is 1. }
  \item{array.order}{ Character vector of array as their order in the barplots, default is the original order in x. }
  \item{array.colour}{ Character vector of colours correspond to the array bars, default is rainbow colours }
  \item{probe.colour}{ Character vector of colours correspond to the probes names of the barplots, default is black. }
  \item{las}{ The las arguments pf par(), default is 1. }
  \item{ps}{ The ps arguments pf par(), default is 8. }
  \item{mar}{ The mar arguments pf par(), default is "c(1.5,3,2.5,1)". }
  \item{main}{ Overall title for the plot of barplots (not the individual barplot of each probe), default is "CORNA barplots". }
  \item{sub}{ Sub title for the plot of barplots, default is none. }
  \item{xlab}{ Title of the x axis, default is none. }
  \item{ylab}{ Title of the y axis, default is none. }
}

\author{
Xikun Wu and Michael Watson
}

\seealso{ corna.line.fun, scale, par, barplot, axis, title }
\examples{
corna.barplot.fun(x=microarray.df, 
                  row=3, column=3,
                  array.order= c("GSM176756", "GSM176758", "GSM176759", "GSM176757", "GSM176760", "GSM176761"), 
                  array.colour=c("red",       "yellow",    "blue",      "green",     "purple",    "orange"),
                  probe.colour=rep("black", 9),
                  ps=10,
                  main="conra barplots of this first 9 probes")
}

\keyword{ hplot }
