\name{KEGG2df.fun}
\alias{KEGG2df.fun}

\title{ Creates data frame of the links of KEGG resource }
\description{
One of the 7 functions prepares the required data objects of the CORNA package.
Based on resource of KEGG, this function creates data frame of the links between genes and pathways.
}
\usage{
KEGG2df.fun(org="mmu",
            kegg2gene.file=NULL, kegg2gene.url=NULL,
            kegg2path.file=NULL, kegg2path.url=NULL,
            path2name.file=NULL, path2name.url=NULL,
            col.new=c("gene", "path", "name")
}
\arguments{
  \item{org}{Three-letter code of organism used in KEGG (e.g. "mmu" for mouse). }       
  \item{kegg2gene.file}{ A local file downloaded from KEGG for links of KEGG gene id and EBSEMBL gene id. }
  \item{kegg2gene.url} { A KEGG web address for links of KEGG gene id and EBSEMBL gene id. }
  \item{kegg2path.file}{ A local file downloaded from KEGG for links of KEGG gene id and pathway id. }
  \item{kegg2path.url} { A KEGG web address for for links of KEGG gene id and pathway id. }
  \item{path2name.file}{ A local file downloaded from KEGG for links of pathway id and pathway name. }
  \item{path2name.url} { A KEGG web address for links of pathway id and pathway name.. }
  \item{col.new}{ A character vector of the column names of the result. }
}

\value{
A data frame of three columns: gene id, pathway id and pathway name.
}
\author{
Xikun Wu and Michael Watson
}
\seealso{ BioMart2df.fun, GEO2df.fun, GO2df.fun, microRNA.org2df.fun, miRBase2df.fun, sam.probe.fun }
\examples{
gene2path.df <- KEGG2df.fun(org="mmu")
gene2path.df <- KEGG2df.fun(kegg2gene.url="ftp://ftp.genome.jp/pub/kegg/genes/organisms/mmu/mmu_ensembl-mmu.list", 
                            kegg2path.url="ftp://ftp.genome.jp/pub/kegg/genes/organisms/mmu/mmu_pathway.list", 
                            path2name.url="ftp://ftp.genome.jp/pub/kegg/pathway/map_title.tab", 
                            col.new=c("gene", "path", "name"))

}
\keyword{ manip }