\name{GEO2df.fun}
\alias{GEO2df.fun}

\title{ Create a data frame of the microarray results }
\description{
One of the 7 functions prepares the required data objects of the CORNA package.
Based on a local soft format GEO file, the web address to download it or the GEO string, 
GEO2df.fun creates a data frame of the microarry results.
}
\usage{
GEO2df.fun(file=NULL, url="ftp://ftp.ncbi.nih.gov/pub/geo/DATA/SOFT/by_series/GSE7333/GSE7333_family.soft.gz", string=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{file}{Local soft format GEO file (e.g. "C:/GSE7333_family.soft").}
  \item{url}{ Web address (e.g. "ftp://ftp.ncbi.nih.gov/pub/geo/DATA/SOFT/by_series/GSE7333/GSE7333_family.soft.gz"). }
  \item{string}{GEO string (e.g. "GSE7333").}
}
\value{
Data frame of the microarray results. Row names represent probes and each column represents a particular array.  
}

\author{
Xikun Wu and Michael Watson
}
\seealso{ BioMart2df.fun, GO2df.fun, KEGG2df.fun, microRNA.org2df.fun, miRBase2df.fun, sam.probe.fun }
\examples{
# they are equivalent   
microarray.df <- GEO2df.fun(file="GSE7333_family.soft")
microarray.df <- GEO2df.fun(file="GSE7333_family.soft.gz")
microarray.df <- GEO2df.fun(url="ftp://ftp.ncbi.nih.gov/pub/geo/DATA/SOFT/by_series/GSE7333/GSE7333_family.soft.gz")
microarray.df <- GEO2df.fun(string="GSE7333") 
}

\keyword{ manip }
