\name{BioMart2df.fun}
\alias{BioMart2df.fun}
\title{Create a data frame of the links between genes and probes}
\description{
One of the 7 functions prepares the required data objects of the CORNA package.
Based on BioMart objects, it creates a data frame representing the links between a few attributes.
}
\usage{
BioMart2df.fun(biomart="ensembl", dataset="mmusculus_gene_ensembl", col.old=c("ensembl_transcript_id"), col.new = c("tran"), complete=FALSE)
}

\arguments{
  \item{biomart}{BioMart database name you want to connect to (e.g. "ensembl").}
  \item{dataset}{BioMart dataset you want to use (e.g. "mmusculus_gene_ensembl").}
  \item{col.old}{Character vector of the attributes (column names) you want to extract.}
  \item{col.new}{Character vector of the column names you want to use in the result.}
  \item{complete}{Logic, if FALSE (default), rows with empty columns are removed; if TRUE, they are kept.}
}

\value{
A data frame of the specific attributes of the BioMart dataset.
}

\author{
Xikun Wu and Michael Watson
}

\seealso{ GEO2df.fun, GO2df.fun, KEGG2df.fun, microRNA.org2df.fun, miRBase2df.fun, sam.probe.fun }

\examples{
library(biomaRt)

biomart <- "ensembl"                        # define BioMart database
dataset <- "mmusculus_gene_ensembl"         # define BioMart dataset

# get links between transcripts and probes of "array affy_mouse430_2"
tran2probe.df <- BioMart2df.fun(biomart=biomart, dataset=dataset, 
                                col.old=c("ensembl_transcript_id", "affy_mouse430_2"),
                                col.new=c("tran", "probe"))

# get links between transcripts and genes
tran2gene.df  <- BioMart2df.fun(biomart=biomart, dataset=dataset, 
                                col.old=c("ensembl_transcript_id", "ensembl_gene_id"),
                                col.new=c("tran", "gene")) 

# get links between transcripts and GO term (biological process)
tran2gobp.df  <- BioMart2df.fun(biomart=biomart, dataset=dataset, 
                                col.old=c("ensembl_transcript_id", "go_biological_process_id"),
                                col.new=c("tran", "gobp"))    

# get links between transcripts and GO term (celluar component)
tran2gocc.df  <- BioMart2df.fun(biomart=biomart, dataset=dataset, 
                                col.old=c("ensembl_transcript_id", "go_cellular_component_id"),
                                col.new=c("tran", "gocc"))    

# get links between transcripts and GO term (molecular function)
tran2gomf.df  <- BioMart2df.fun(biomart=biomart, dataset=dataset, 
                                col.old=c("ensembl_transcript_id", "go_molecular_function_id"),
                                col.new=c("tran", "gomf"))  
}

\keyword{ manip }
