`getfile.fun` <-
function(url=NULL, file=NULL){
  if(is.null(file)){                        # if file not defined
    if(!is.null(url)){                      # download it if url is defined
      v <- unlist(strsplit(url, "/"))
      file <- v[length(v)]
      download.file(url, file)
    }
    else{
      stop("Please supply a either a filename or the url of downloading it.")
    }
  }
  
  if(length(grep("\\.gz$", file, perl=T))>0){
    gunzip(file, overwrite=T, remove=F)
    file <- gsub("\\.gz$", "", file)
  }
    
  if(length(grep("\\.zip$", file, perl=T))>0){
    n <- sub("\\.zip$", "", file)
    n <- sub("^arch\\.", "", n)
    file <- zip.file.extract(n, file)
  }
  
  return(file)
}

