`corna.barplot.fun` <-
function(x, scale.data=T, row=1, column=1, 
         array.order=c(1:ncol(x)), 
         array.colour=rainbow(length(array.order)), 
         probe.colour=rep("black", nrow(x)), 
         las=1, ps=8, mar=c(1.5,3,2.5,1), 
         main="CORNA barplots", sub="", xlab="", ylab="", line=NA, outer=F){
  d <- na.omit(x[, array.order])
  n <- ncol(d)
  if(is.null(probe.colour)) {probe.colour <- rainbow(nrow(d))}   
  if(scale.data==T){d[,1:n] <- t(scale(t(d[,1:n])))}   
  
  split.screen(c(row, column), erase=TRUE)
  erase.screen()
  for(i in 1:min(nrow(d),(row*column)))
  {
    screen(i)
    par(las=las, ps=ps, mar=mar) 
    barplot(c(as.matrix(d[i,1:n])), col=array.colour)
    axis(1, at=ncol(d)/2, lab=rownames(x)[i], line=-1, col="black", tick=F, col.axis=probe.colour[i])
  }
  close.screen(all = TRUE) 
  title(main=main, sub=sub, xlab=xlab, ylab=ylab, line=line, outer=outer)
}     