\name{pvalstest_logrank}
\alias{pvalstest_logrank}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Permutation p-values for copy number data}
\description{
  This function provides raw permutation p-values for the logrank test on discretized copy number data and survival data. It also provides a permutation matrix of p-values which may be used for estimating False Discovery Rate.
}
\usage{
pvalstest_logrank(datacgh, data.info, dataclinvar,whtime=1, whstatus=2, lgonly = 0, af = 0, niter = 1000)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{datacgh}{A data frame containing discretized aCGH data}
 \item{data.info}{A data frame containing genomic information on the aCGH data (chromosome, base pair position, etc)}
  \item{dataclinvar}{A .txt file containing survival information. Order of rows (in terms of samples) should be the same as the order of the columns in Xmat. Survival times should be numbers, status: 0 = alive, 1 = death.}
  \item{whtime}{The number of the column containing survival time}
  \item{whstatus}{The number of the column containing survival status}
  \item{lgonly}{What states do you wish to compare? Options: -1 for losses vs non-loss, 1 for gain vs non-gain, 0 for all 3}
  \item{af}{Filter out regions with less than af*100 perc. aberrations}
  \item{niter}{number of permutations. At least 10.000 recommended for final calculations}
}
\details{
On lgonly: 0 is most powerful, while -1 (or 1) can be better interpretable. Computation time is mostly determined by the number of permutations. Note that this function provides besides the raw p-values, an estimation of the null p-value distributions (which may be highly non-uniform for these data!) which is useful for estimating fdr. 
}
\value{
  \item{pvals}{A vector of raw p-values}
  \item{pvperm}{A matrix containing niter columns of permutation p-values}
  \item{info}{Data frame containing information on the regions tested}
}

\author{Mark A. van de Wiel}

\examples{
data(datalung)
data(survdat)
datainfo <- datalung[,1:5]
datacgh <- datalung[,-(1:5)]
\dontrun{pvs <- pvalstest_logrank(datacgh,datainfo,dataclinvar=survdat,whtime=1,whstatus=2,af=0.1,niter=10000)}
}



