### R code from vignette source 'methylumi.Rnw'

###################################################
### code chunk number 1: init
###################################################
options(width=50)
library(lattice)
library(xtable)


###################################################
### code chunk number 2: methylumi.Rnw:51-57
###################################################
library(methylumi)
samps <- read.table(system.file("extdata/samples.txt",
                                package = "methylumi"),sep="\t",header=TRUE)
mldat <- methylumiR(system.file('extdata/exampledata.samples.txt',package='methylumi'),
                    qcfile=system.file('extdata/exampledata.controls.txt',package="methylumi"),
                    sampleDescriptions=samps)


###################################################
### code chunk number 3: methylumi.Rnw:61-62
###################################################
mldat


###################################################
### code chunk number 4: methylumi.Rnw:69-70
###################################################
getAssayDataNameSubstitutions()


###################################################
### code chunk number 5: methylumi.Rnw:77-78
###################################################
md <- cmdscale(dist(t(exprs(mldat)[fData(mldat)$CHROMOSOME=='X',])),2)


###################################################
### code chunk number 6: methylumi.Rnw:81-82
###################################################
plot(md,pch=c('F','M')[pData(mldat)$Gender],col=c('red','blue')[pData(mldat)$Gender])


###################################################
### code chunk number 7: methylumi.Rnw:87-90
###################################################
avgPval <- colMeans(pvals(mldat))
par(las=2)
barplot(avgPval,ylab="Average P-Value")


###################################################
### code chunk number 8: methylumi.Rnw:97-98
###################################################
controlTypes(mldat)


###################################################
### code chunk number 9: methylumi.Rnw:103-104
###################################################
qcplot(mldat,"FIRST HYBRIDIZATION")


###################################################
### code chunk number 10: methylumi.Rnw:115-118
###################################################
toKeep <- (avgPval<0.05)
pData(mldat)$Gender[9] <- "F"
mldat.norm <- normalizeMethyLumiSet(mldat[,toKeep])


###################################################
### code chunk number 11: methylumi.Rnw:125-133
###################################################
library(limma)
dm <- model.matrix(~1+Gender,data=pData(mldat.norm))
colnames(dm)
fit1 <- lmFit(exprs(mldat.norm),dm)
fit2 <- eBayes(fit1)
tt <- topTable(fit2,coef=2,genelist=fData(mldat.norm)[,c('SYMBOL','CHROMOSOME')],number=1536)
x <- aggregate(tt$adj.P.Val,by=list(tt$CHROMOSOME),median)
colnames(x) <- c('Chromosome','Median adjusted P-value')


###################################################
### code chunk number 12: methylumi.Rnw:136-140
###################################################
library(xtable)
xt <- xtable(x,label="tab:chromosomepvals",caption="The median adjusted p-value for each chromosome showing that the X-chromosome is highly significantly different between males and females")
digits(xt) <- 6
print(xt,include.rownames=FALSE,align="cr")


###################################################
### code chunk number 13: methylumi.Rnw:145-150
###################################################
pdf('gender_probes_by_chrom.pdf')
print(xyplot(-log10(adj.P.Val)~CHROMOSOME,
       tt,ylab="-log10(Adjusted P-value)",
       main="P-values for probes\ndistinguising males from females"))
invisible(dev.off())


###################################################
### code chunk number 14: methylumi.Rnw:162-163
###################################################
toLatex(sessionInfo())


