### R code from vignette source 'hm27kOn450k.Rnw'

###################################################
### code chunk number 1: load library and identify 27k probes
###################################################
library('IlluminaHumanMethylation450k.db')
probes.27k <- IlluminaHumanMethylation450k_get27k()
lapply(probes.27k, function(x) {
  if( class(x) == 'list') lapply(x, head)
  else head(x)
})


###################################################
### code chunk number 2: list the 27k probe IDs
###################################################
probes.27k <- unlist(probes.27k, recursive=T)
head(mget(probes.27k, IlluminaHumanMethylation450kPROBELOCATION, ifnotfound=NA))


###################################################
### code chunk number 3: annotate the 27k probes
###################################################

probeloc <- mget(probes.27k, IlluminaHumanMethylation450kPROBELOCATION, 
                 ifnotfound=NA)

body.or.exon <- function(x) length( grep('(Body|Exon)', x) ) > 0
length(which(unlist(lapply(probeloc, body.or.exon))))

in.body <- function(x) length( grep('Body', x) ) > 0 
gene.body.probes <- names(which(unlist(lapply(probeloc, in.body))))
length(which(unlist(lapply(probeloc, in.body))))
head(gene.body.probes)


###################################################
### code chunk number 4: identify database and package versions
###################################################
IlluminaHumanMethylation450k_dbInfo()[c(8:10,22:24,31,33),]
IlluminaHumanMethylation450kSVNID
IlluminaHumanMethylation450kBLAME


###################################################
### code chunk number 5: hm27kOn450k.Rnw:89-90
###################################################
toLatex(sessionInfo())


