### R code from vignette source 'IntroToAnnotationPackages.Rnw'

###################################################
### code chunk number 1: loadChip
###################################################
library(hgu95av2.db)


###################################################
### code chunk number 2: listContents
###################################################
ls("package:hgu95av2.db")


###################################################
### code chunk number 3: show
###################################################
hgu95av2.db


###################################################
### code chunk number 4: cols
###################################################
cols(hgu95av2.db)


###################################################
### code chunk number 5: help (eval = FALSE)
###################################################
## help("SYMBOL")


###################################################
### code chunk number 6: keytypes
###################################################
keytypes(hgu95av2.db)


###################################################
### code chunk number 7: keys
###################################################
head(keys(hgu95av2.db, keytype="SYMBOL"))


###################################################
### code chunk number 8: selectChip
###################################################
#1st get some example keys
k <- head(keys(hgu95av2.db,keytype="PROBEID"))
# then call select
select(hgu95av2.db, keys=k, cols=c("SYMBOL","GENENAME"), keytype="PROBEID")


###################################################
### code chunk number 9: selectOrg1
###################################################
library(org.Hs.eg.db)
cols(org.Hs.eg.db)


###################################################
### code chunk number 10: selectOrg2 (eval = FALSE)
###################################################
## help("SYMBOL") ## for explanation of these cols and keytypes values


###################################################
### code chunk number 11: selectOrg3
###################################################
keytypes(org.Hs.eg.db)
uniKeys <- head(keys(org.Hs.eg.db, keytype="UNIPROT"))
cols <- c("SYMBOL", "PATH")
select(org.Hs.eg.db, keys=uniKeys, cols=cols, keytype="UNIPROT")


###################################################
### code chunk number 12: selectData
###################################################
load(system.file("extdata", "resultTable.Rda", package="AnnotationDbi"))
head(resultTable)


###################################################
### code chunk number 13: selectOrgData
###################################################
annots <- select(org.Hs.eg.db, keys=rownames(resultTable),
                 cols=c("SYMBOL","GENENAME"), keytype="ENTREZID")
resultTable <- merge(resultTable, annots, by.x=0, by.y="ENTREZID")
head(resultTable)


###################################################
### code chunk number 14: selectGO
###################################################
library(GO.db)
GOIDs <- c("GO:0042254","GO:0044183")
select(GO.db, keys=GOIDs, cols="DEFINITION", keytype="GOID")


###################################################
### code chunk number 15: selectTxDb
###################################################
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
txdb
cols(txdb)
keytypes(txdb)
keys <- head(keys(txdb, keytype="GENEID"))
cols <- c("TXID", "TXSTART")
select(txdb, keys=keys, cols=cols, keytype="GENEID")



###################################################
### code chunk number 16: getMetadata
###################################################
library(hom.Hs.inp.db)
hom.Hs.inp_dbInfo()


###################################################
### code chunk number 17: referenceClass (eval = FALSE)
###################################################
## .InparanoidDb <-
##     setRefClass("InparanoidDb", contains="AnnotationDb")


###################################################
### code chunk number 18: onLoad (eval = FALSE)
###################################################
## sPkgname <- sub(".db$","",pkgname)
## txdb <- loadDb(system.file("extdata", paste(sPkgname,
##                ".sqlite",sep=""), package=pkgname, lib.loc=libname),
##                packageName=pkgname)
## dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"InparanoidDb")
## ns <- asNamespace(pkgname)
## assign(dbNewname, txdb, envir=ns)
## namespaceExport(ns, dbNewname)


###################################################
### code chunk number 19: classicConn
###################################################
drv <- SQLite()
library("org.Hs.eg.db")
con <- dbConnect(drv, dbname=system.file("extdata", "org.Hs.eg.sqlite",
                        package = "org.Hs.eg.db"))
con
dbDisconnect(con)


###################################################
### code chunk number 20: ourConn
###################################################
str(hom.Hs.inp.db)


###################################################
### code chunk number 21: ourConn2
###################################################
hom.Hs.inp.db$conn
## or better we can use a helper function to wrap this:
AnnotationDbi:::dbConn(hom.Hs.inp.db)
## or we can just call the provided convenience function 
## from when this package loads:
hom.Hs.inp_dbconn()


###################################################
### code chunk number 22: dbListTables
###################################################
con <- AnnotationDbi:::dbConn(hom.Hs.inp.db)
head(dbListTables(con))
dbListFields(con, "Mus_musculus")


###################################################
### code chunk number 23: dbGetQuery
###################################################
dbGetQuery(con, "SELECT * FROM metadata")


###################################################
### code chunk number 24: dbListTables2
###################################################
head(dbListTables(con))


###################################################
### code chunk number 25: dbListFields2
###################################################
dbListFields(con, "Apis_mellifera")


###################################################
### code chunk number 26: dbGetQuery2
###################################################
head(dbGetQuery(con, "SELECT * FROM Apis_mellifera"))


###################################################
### code chunk number 27: Anopheles (eval = FALSE)
###################################################
## head(dbGetQuery(con, "SELECT * FROM Anopheles_gambiae"))
## ## Then only retrieve human records
## ## Query: SELECT * FROM Anopheles_gambiae WHERE species='HOMSA'
## head(dbGetQuery(con, "SELECT * FROM Anopheles_gambiae WHERE species='HOMSA'"))
## dbDisconnect(con)


###################################################
### code chunk number 28: cols (eval = FALSE)
###################################################
## .cols <- function(x){
##   con <- AnnotationDbi:::dbConn(x)
##   list <- dbListTables(con)
##   ## drop unwanted tables
##   unwanted <- c("map_counts","map_metadata","metadata")
##   list <- list[!list %in% unwanted]
##   ## Then just to format things in the usual way
##   list <- toupper(list)
##   dbDisconnect(con)
##   list
## }
## 
## ## Then make this into a method
## setMethod("cols", "InparanoidDb", .cols(x))
## ## Then we can call it
## cols(hom.Hs.inp.db)


###################################################
### code chunk number 29: keytypes (eval = FALSE)
###################################################
## setMethod("keytypes", "InparanoidDb", .cols(x))
## ## Then we can call it
## keytypes(hom.Hs.inp.db)
## 
## ## refactor of .cols
## .getLCcolnames <- function(x){
##   con <- AnnotationDbi:::dbConn(x)
##   list <- dbListTables(con)
##   ## drop unwanted tables
##   unwanted <- c("map_counts","map_metadata","metadata")
##   list <- list[!list %in% unwanted]
##   dbDisconnect(con)
##   list
## }
## .cols <- function(x){
##   list <- .getLCcolnames(x)
##   ## Then just to format things in the usual way
##   toupper(list)
## }
## ## Test:
## cols(hom.Hs.inp.db)
## 
## ## new helper function:
## .getTableNames <- function(x){
##   LC <- .getLCcolnames(x)
##   UC <- .cols(x)
##   names(UC) <- LC
##   UC
## }
## .getTableNames(hom.Hs.inp.db)


###################################################
### code chunk number 30: keys (eval = FALSE)
###################################################
## .keys <- function(x, keytype){
##   ## translate keytype back to table name
##   tabNames <- .getTableNames(x)
##   lckeytype <- names(tabNames[tabNames %in% keytype])
##   ## get a connection
##   con <- AnnotationDbi:::dbConn(x)
##   sql <- paste("SELECT inp_id FROM",lckeytype, "WHERE species!='HOMSA'")
##   res <- dbGetQuery(con, sql)
##   res <- as.vector(t(res))
##   dbDisconnect(con)
##   res
## }
## 
## setMethod("keys", "InparanoidDb", .keys(x, keytype))
## ## Then we can call it
## keys(hom.Hs.inp.db, "TRICHOPLAX_ADHAERENS")


