/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import com.google.java.contract.Requires;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.util.StringUtil;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.utils.text.TextFormattingUtils;

public class Utils {
    private static Logger logger = Logger.getLogger(Utils.class);
    public static final float JAVA_DEFAULT_HASH_LOAD_FACTOR = 0.75f;

    public static int optimumHashSize(int maxElements) {
        return (int)((float)maxElements / 0.75f) + 2;
    }

    public static boolean equals(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null) {
            return false;
        }
        return lhs.equals(rhs);
    }

    public static <T> List<T> cons(T elt, List<T> l) {
        ArrayList<T> l2 = new ArrayList<T>();
        l2.add(elt);
        if (l != null) {
            l2.addAll(l);
        }
        return l2;
    }

    public static void warnUser(String msg) {
        Utils.warnUser(logger, msg);
    }

    public static void warnUser(Logger logger, String msg) {
        logger.warn(String.format("********************************************************************************", new Object[0]));
        logger.warn(String.format("* WARNING:", new Object[0]));
        logger.warn(String.format("*", new Object[0]));
        Utils.prettyPrintWarningMessage(logger, msg);
        logger.warn(String.format("********************************************************************************", new Object[0]));
    }

    private static void prettyPrintWarningMessage(Logger logger, String message) {
        StringBuilder builder = new StringBuilder(message);
        while (builder.length() > 70) {
            int space = builder.lastIndexOf(" ", 70);
            if (space <= 0) {
                space = 70;
            }
            logger.warn(String.format("* %s", builder.substring(0, space)));
            builder.delete(0, space + 1);
        }
        logger.warn(String.format("* %s", builder));
    }

    public static ArrayList<Byte> subseq(char[] fullArray) {
        byte[] fullByteArray = new byte[fullArray.length];
        StringUtil.charsToBytes(fullArray, 0, fullArray.length, fullByteArray, 0);
        return Utils.subseq(fullByteArray);
    }

    public static ArrayList<Byte> subseq(byte[] fullArray) {
        return Utils.subseq(fullArray, 0, fullArray.length - 1);
    }

    public static ArrayList<Byte> subseq(byte[] fullArray, int start, int end) {
        assert (end < fullArray.length);
        ArrayList<Byte> dest = new ArrayList<Byte>(end - start + 1);
        for (int i = start; i <= end; ++i) {
            dest.add(fullArray[i]);
        }
        return dest;
    }

    public static String baseList2string(List<Byte> bases) {
        byte[] basesAsbytes = new byte[bases.size()];
        int i = 0;
        for (Byte b : bases) {
            basesAsbytes[i] = b;
            ++i;
        }
        return new String(basesAsbytes);
    }

    public static <L, R> String joinMap(String keyValueSeperator, String recordSeperator, Map<L, R> map) {
        if (map.size() < 1) {
            return null;
        }
        String[] joinedKeyValues = new String[map.size()];
        int index = 0;
        for (L key : map.keySet()) {
            joinedKeyValues[index++] = String.format("%s%s%s", key.toString(), keyValueSeperator, map.get(key).toString());
        }
        return Utils.join(recordSeperator, joinedKeyValues);
    }

    public static ArrayList<String> split(String str, String delimiter) {
        return Utils.split(str, delimiter, 10);
    }

    public static ArrayList<String> split(String str, String delimiter, int expectedNumTokens) {
        ArrayList<String> result = new ArrayList<String>(expectedNumTokens);
        int delimiterIdx = -1;
        do {
            int tokenStartIdx;
            String token = (delimiterIdx = str.indexOf(delimiter, tokenStartIdx = delimiterIdx + 1)) != -1 ? str.substring(tokenStartIdx, delimiterIdx) : str.substring(tokenStartIdx);
            result.add(token);
        } while (delimiterIdx != -1);
        return result;
    }

    public static String join(String separator, String[] strings) {
        return Utils.join(separator, strings, 0, strings.length);
    }

    public static String join(String separator, String[] strings, int start, int end) {
        if (end - start == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(strings[start]);
        for (int i = start + 1; i < end; ++i) {
            ret.append(separator);
            ret.append(strings[i]);
        }
        return ret.toString();
    }

    public static String join(String separator, int[] ints) {
        if (ints == null || ints.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(ints[0]);
        for (int i = 1; i < ints.length; ++i) {
            ret.append(separator);
            ret.append(ints[i]);
        }
        return ret.toString();
    }

    public static <T> String join(String separator, Collection<T> objects) {
        if (objects.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objects.iterator();
        T first = iter.next();
        if (!iter.hasNext()) {
            return first.toString();
        }
        StringBuilder ret = new StringBuilder(first.toString());
        while (iter.hasNext()) {
            ret.append(separator);
            ret.append(iter.next().toString());
        }
        return ret.toString();
    }

    public static String dupString(char c, int nCopies) {
        char[] chars = new char[nCopies];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    public static byte[] dupBytes(byte b, int nCopies) {
        byte[] bytes = new byte[nCopies];
        Arrays.fill(bytes, b);
        return bytes;
    }

    public static String trim(String str, char ch) {
        int end;
        int start;
        char[] array = str.toCharArray();
        for (start = 0; start < array.length && array[start] == ch; ++start) {
        }
        for (end = array.length - 1; end > start && array[end] == ch; --end) {
        }
        return str.substring(start, end + 1);
    }

    public static byte listMaxByte(List<Byte> quals) {
        if (quals.size() == 0) {
            return 0;
        }
        byte m = quals.get(0);
        for (byte b : quals) {
            m = b > m ? b : m;
        }
        return m;
    }

    public static String[] escapeExpressions(String args) {
        if (args.indexOf(39) != -1) {
            return Utils.escapeExpressions(args, "'");
        }
        if (args.indexOf(34) != -1) {
            return Utils.escapeExpressions(args, "\"");
        }
        return args.trim().split(" +");
    }

    private static String[] escapeExpressions(String args, String delimiter) {
        String arg;
        String[] command = new String[]{};
        String[] split = args.split(delimiter);
        for (int i = 0; i < split.length - 1; i += 2) {
            arg = split[i].trim();
            if (arg.length() > 0) {
                command = Utils.concatArrays(command, arg.split(" +"));
            }
            command = Utils.concatArrays(command, new String[]{split[i + 1]});
        }
        arg = split[split.length - 1].trim();
        if (split.length % 2 == 1 && arg.length() > 0) {
            command = Utils.concatArrays(command, arg.split(" +"));
        }
        return command;
    }

    public static String[] concatArrays(String[] A, String[] B) {
        String[] C = new String[A.length + B.length];
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }

    public static String[] appendArray(String[] A, String ... B) {
        return Utils.concatArrays(A, B);
    }

    public static int[] indexOfAll(String s, int ch) {
        int[] pos = new int[64];
        int z = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ch) continue;
            pos[z++] = i;
        }
        return Utils.reallocate(pos, z);
    }

    public static int countSetBits(boolean[] array) {
        int counter = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            ++counter;
        }
        return counter;
    }

    public static int[] reallocate(int[] orig, int newSize) {
        if (orig.length == newSize) {
            return orig;
        }
        int[] new_array = new int[newSize];
        int L = newSize > orig.length ? orig.length : newSize;
        for (int i = 0; i < L; ++i) {
            new_array[i] = orig[i];
        }
        return new_array;
    }

    public static byte[] extend(byte[] a, int n, byte v) {
        int i;
        if (n > 0) {
            byte[] newA = Arrays.copyOf(a, a.length + n);
            if (v != 0) {
                for (int i2 = a.length; i2 < newA.length; ++i2) {
                    newA[i2] = v;
                }
            }
            return newA;
        }
        n = -n;
        byte[] newA = new byte[a.length + n];
        if (v != 0) {
            for (i = 0; i < n; ++i) {
                newA[i] = v;
            }
        } else {
            i = n;
        }
        for (int j = 0; j < a.length; ++j) {
            newA[i] = a[j];
            ++i;
        }
        return newA;
    }

    public static short[] extend(short[] a, int n, short v) {
        int i;
        if (n > 0) {
            short[] newA = Arrays.copyOf(a, a.length + n);
            if (v != 0) {
                for (int i2 = a.length; i2 < newA.length; ++i2) {
                    newA[i2] = v;
                }
            }
            return newA;
        }
        n = -n;
        short[] newA = new short[a.length + n];
        if (v != 0) {
            for (i = 0; i < n; ++i) {
                newA[i] = v;
            }
        } else {
            i = n;
        }
        for (int j = 0; j < a.length; ++j) {
            newA[i] = a[j];
            ++i;
        }
        return newA;
    }

    public static char stringToChar(String str) {
        if (str.length() != 1) {
            throw new IllegalArgumentException("String length must be one");
        }
        return str.charAt(0);
    }

    public static <T extends Comparable<T>> List<T> sorted(Collection<T> c) {
        return Utils.sorted(c, false);
    }

    public static <T extends Comparable<T>> List<T> sorted(Collection<T> c, boolean reverse) {
        ArrayList<T> l = new ArrayList<T>(c);
        Collections.sort(l);
        if (reverse) {
            Collections.reverse(l);
        }
        return l;
    }

    public static <T extends Comparable<T>, V> List<V> sorted(Map<T, V> c) {
        return Utils.sorted(c, false);
    }

    public static <T extends Comparable<T>, V> List<V> sorted(Map<T, V> c, boolean reverse) {
        ArrayList<T> t = new ArrayList<T>(c.keySet());
        Collections.sort(t);
        if (reverse) {
            Collections.reverse(t);
        }
        ArrayList<V> l = new ArrayList<V>();
        for (Comparable k : t) {
            l.add(c.get(k));
        }
        return l;
    }

    public static <T extends Comparable<T>, V> String sortedString(Map<T, V> c) {
        ArrayList<T> t = new ArrayList<T>(c.keySet());
        Collections.sort(t);
        ArrayList<String> pairs = new ArrayList<String>();
        for (Comparable k : t) {
            pairs.add(k + "=" + c.get(k));
        }
        return "{" + Utils.join(", ", pairs) + "}";
    }

    public static byte[] reverse(byte[] bases) {
        byte[] rcbases = new byte[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = bases[bases.length - i - 1];
        }
        return rcbases;
    }

    public static final <T> List<T> reverse(List<T> l) {
        ArrayList<T> newL = new ArrayList<T>(l);
        Collections.reverse(newL);
        return newL;
    }

    public static int[] reverse(int[] bases) {
        int[] rcbases = new int[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = bases[bases.length - i - 1];
        }
        return rcbases;
    }

    public static String reverse(String bases) {
        return new String(Utils.reverse(bases.getBytes()));
    }

    public static byte[] charSeq2byteSeq(char[] seqIn) {
        byte[] seqOut = new byte[seqIn.length];
        for (int i = 0; i < seqIn.length; ++i) {
            seqOut[i] = (byte)seqIn[i];
        }
        return seqOut;
    }

    public static boolean isFlagSet(int value, int flag) {
        return (value & flag) == flag;
    }

    public static final String resolveHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            return "unresolvable";
        }
    }

    public static byte[] arrayFromArrayWithLength(byte[] array, int length) {
        byte[] output = new byte[length];
        for (int j = 0; j < length; ++j) {
            output[j] = array[j % array.length];
        }
        return output;
    }

    public static void fillArrayWithByte(byte[] array, byte value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void setupWriter(StingSAMFileWriter writer, GenomeAnalysisEngine toolkit, boolean preSorted, boolean KEEP_ALL_PG_RECORDS, Object walker, String PROGRAM_RECORD_NAME) {
        SAMProgramRecord programRecord = Utils.createProgramRecord(toolkit, walker, PROGRAM_RECORD_NAME);
        SAMFileHeader header = toolkit.getSAMFileHeader();
        List<SAMProgramRecord> oldRecords = header.getProgramRecords();
        ArrayList<SAMProgramRecord> newRecords = new ArrayList<SAMProgramRecord>(oldRecords.size() + 1);
        for (SAMProgramRecord record : oldRecords) {
            if (record.getId().startsWith(PROGRAM_RECORD_NAME) && !KEEP_ALL_PG_RECORDS) continue;
            newRecords.add(record);
        }
        newRecords.add(programRecord);
        header.setProgramRecords(newRecords);
        writer.writeHeader(header);
        writer.setPresorted(preSorted);
    }

    public static SAMProgramRecord createProgramRecord(GenomeAnalysisEngine toolkit, Object walker, String PROGRAM_RECORD_NAME) {
        SAMProgramRecord programRecord = new SAMProgramRecord(PROGRAM_RECORD_NAME);
        ResourceBundle headerInfo = TextFormattingUtils.loadResourceBundle("StingText");
        try {
            String version = headerInfo.getString("org.broadinstitute.sting.gatk.version");
            programRecord.setProgramVersion(version);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        programRecord.setCommandLine(toolkit.createApproximateCommandLineArgumentString(toolkit, walker));
        return programRecord;
    }

    public static <E> Collection<E> makeCollection(Iterable<E> iter) {
        ArrayList<E> list = new ArrayList<E>();
        for (E item : iter) {
            list.add(item);
        }
        return list;
    }

    @Requires(value={"options != null"})
    public static <T> int nCombinations(Collection<T>[] options) {
        int nStates = 1;
        for (Collection<T> states : options) {
            nStates *= states.size();
        }
        return nStates;
    }

    @Requires(value={"options != null"})
    public static <T> int nCombinations(List<List<T>> options) {
        if (options.isEmpty()) {
            return 0;
        }
        int nStates = 1;
        for (List<T> states : options) {
            nStates *= states.size();
        }
        return nStates;
    }

    public static <T> List<List<T>> makePermutations(List<T> objects, int n, boolean withReplacement) {
        ArrayList<List<T>> combinations;
        block5: {
            combinations = new ArrayList<List<T>>();
            if (n <= 0) break block5;
            if (n == 1) {
                for (T o : objects) {
                    combinations.add(Collections.singletonList(o));
                }
            } else {
                List<List<T>> sub = Utils.makePermutations(objects, n - 1, withReplacement);
                for (List<T> subI : sub) {
                    for (T a : objects) {
                        if (!withReplacement && subI.contains(a)) continue;
                        combinations.add(Utils.cons(a, subI));
                    }
                }
            }
        }
        return combinations;
    }

    public static String formattedNoveltyRate(int known, int all) {
        return Utils.formattedPercent(all - known, all);
    }

    public static String formattedPercent(long x, long total) {
        return total == 0L ? "NA" : String.format("%.2f", 100.0 * (double)x / (double)total);
    }

    public static String formattedRatio(long num, long denom) {
        return denom == 0L ? "NA" : String.format("%.2f", (double)num / (1.0 * (double)denom));
    }

    public static <T> Map<T, T> makeIdentityFunctionMap(Collection<T> values) {
        HashMap<T, T> map = new HashMap<T, T>(values.size());
        for (T value : values) {
            map.put(value, value);
        }
        return Collections.unmodifiableMap(map);
    }
}

