/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFStandardHeaderLines;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;
import org.broadinstitute.sting.utils.variantcontext.writer.VariantContextWriter;

@DocumentedGATKFeature(groupName="Validation Utilities", extraDocs={CommandLineGATK.class})
@Reference(window=@Window(start=0, stop=40))
public class VariantValidationAssessor
extends RodWalker<VariantContext, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Output(doc="File to which variants should be written", required=true)
    protected VariantContextWriter vcfwriter = null;
    @Argument(fullName="maxHardy", doc="Maximum phred-scaled Hardy-Weinberg violation pvalue to consider an assay valid", required=false)
    protected double maxHardy = 20.0;
    @Argument(fullName="maxNoCall", doc="Maximum no-call rate (as a fraction) to consider an assay valid", required=false)
    protected double maxNoCall = 0.05;
    @Argument(fullName="maxHomVar", doc="Maximum homozygous variant rate (as a fraction) to consider an assay valid", required=false)
    protected double maxHomNonref = 1.1;
    private TreeSet<String> sampleNames = null;
    private ArrayList<VariantContext> records = new ArrayList();
    private int numRecords = 0;
    private int numHWViolations = 0;
    private int numNoCallViolations = 0;
    private int numHomVarViolations = 0;
    private int numTrueVariants = 0;

    @Override
    public void initialize() {
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public VariantContext map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return null;
        }
        VariantContext vc = tracker.getFirstValue(this.variantCollection.variants, ref.getLocus());
        if (vc == null) {
            return null;
        }
        if (this.sampleNames == null) {
            this.sampleNames = new TreeSet<String>(vc.getSampleNames());
        }
        return this.addVariantInformationToCall(vc);
    }

    @Override
    public Integer reduce(VariantContext call, Integer numVariants) {
        if (call != null) {
            Integer n = numVariants;
            Integer n2 = numVariants = Integer.valueOf(numVariants + 1);
            this.records.add(call);
        }
        return numVariants;
    }

    @Override
    public void onTraversalDone(Integer finalReduce) {
        List<String> inputNames = Arrays.asList(this.variantCollection.variants.getName());
        HashSet<VCFHeaderLine> hInfo = new HashSet<VCFHeaderLine>();
        hInfo.addAll(VCFUtils.getHeaderFields(this.getToolkit(), inputNames));
        hInfo.add(new VCFInfoHeaderLine("NoCallPct", 1, VCFHeaderLineType.Float, "Percent of no-calls"));
        hInfo.add(new VCFInfoHeaderLine("HomRefPct", 1, VCFHeaderLineType.Float, "Percent of homozygous reference genotypes"));
        hInfo.add(new VCFInfoHeaderLine("HetPct", 1, VCFHeaderLineType.Float, "Percent of heterozygous genotypes"));
        hInfo.add(new VCFInfoHeaderLine("HomVarPct", 1, VCFHeaderLineType.Float, "Percent homozygous variant genotypes"));
        hInfo.add(new VCFInfoHeaderLine("HW", 1, VCFHeaderLineType.Float, "Phred-scaled Hardy-Weinberg violation p-value"));
        hInfo.add(VCFStandardHeaderLines.getInfoLine("AC"));
        hInfo.add(VCFStandardHeaderLines.getInfoLine("AN"));
        hInfo.add(new VCFFilterHeaderLine("HardyWeinbergViolation", "The validation is in Hardy-Weinberg violation"));
        hInfo.add(new VCFFilterHeaderLine("HighNoCallRate", "The validation no-call rate is too high"));
        hInfo.add(new VCFFilterHeaderLine("TooManyHomVars", "The validation homozygous variant rate is too high"));
        System.out.println(String.format("Total number of samples assayed:\t\t\t%d", this.sampleNames.size()));
        hInfo.add(new VCFHeaderLine("ValidationMetrics_SamplesAssayed", String.format("%d", this.sampleNames.size())));
        System.out.println(String.format("Total number of records processed:\t\t\t%d", this.numRecords));
        hInfo.add(new VCFHeaderLine("ValidationMetrics_RecordsProcessed", String.format("%d", this.numRecords)));
        if (this.numRecords > 0) {
            System.out.println(String.format("Number of Hardy-Weinberg violations:\t\t\t%d (%d%%)", this.numHWViolations, 100 * this.numHWViolations / this.numRecords));
            hInfo.add(new VCFHeaderLine("ValidationMetrics_HardyWeinbergViolations", String.format("\"%d (%d%%)\"", this.numHWViolations, 100 * this.numHWViolations / this.numRecords)));
            System.out.println(String.format("Number of no-call violations:\t\t\t\t%d (%d%%)", this.numNoCallViolations, 100 * this.numNoCallViolations / this.numRecords));
            hInfo.add(new VCFHeaderLine("ValidationMetrics_NoCallViolations", String.format("\"%d (%d%%)\"", this.numNoCallViolations, 100 * this.numNoCallViolations / this.numRecords)));
            System.out.println(String.format("Number of homozygous variant violations:\t\t%d (%d%%)", this.numHomVarViolations, 100 * this.numHomVarViolations / this.numRecords));
            hInfo.add(new VCFHeaderLine("ValidationMetrics_HomVarViolations", String.format("\"%d (%d%%)\"", this.numHomVarViolations, 100 * this.numHomVarViolations / this.numRecords)));
            int goodRecords = this.numRecords - this.numHWViolations - this.numNoCallViolations - this.numHomVarViolations;
            System.out.println(String.format("Number of records passing all filters:\t\t\t%d (%d%%)", goodRecords, 100 * goodRecords / this.numRecords));
            hInfo.add(new VCFHeaderLine("ValidationMetrics_RecordsPassingFilters", String.format("\"%d (%d%%)\"", goodRecords, 100 * goodRecords / this.numRecords)));
            if (goodRecords > 0) {
                System.out.println(String.format("Number of passing records that are polymorphic:\t\t%d (%d%%)", this.numTrueVariants, 100 * this.numTrueVariants / goodRecords));
                hInfo.add(new VCFHeaderLine("ValidationMetrics_PolymorphicPassingRecords", String.format("\"%d (%d%%)\"", this.numTrueVariants, 100 * this.numTrueVariants / goodRecords)));
            }
        }
        this.vcfwriter.writeHeader(new VCFHeader(hInfo, SampleUtils.getUniqueSamplesFromRods(this.getToolkit(), inputNames)));
        for (VariantContext record : this.records) {
            this.vcfwriter.add(record);
        }
    }

    private VariantContext addVariantInformationToCall(VariantContext vContext) {
        int altAlleleCount;
        double hwPvalue = this.hardyWeinbergCalculation(vContext);
        double hwScore = Math.abs(QualityUtils.phredScaleErrorRate(hwPvalue));
        double noCallProp = (double)vContext.getNoCallCount() / (double)vContext.getNSamples();
        double homRefProp = (double)vContext.getHomRefCount() / (double)vContext.getNSamples();
        double hetProp = (double)vContext.getHetCount() / (double)vContext.getNSamples();
        double homVarProp = (double)vContext.getHomVarCount() / (double)vContext.getNSamples();
        boolean isViolation = false;
        HashSet<String> filters = new HashSet<String>();
        if (noCallProp > this.maxNoCall) {
            filters.add("HighNoCallRate");
            ++this.numNoCallViolations;
            isViolation = true;
        } else if (hwScore > this.maxHardy) {
            filters.add("HardyWeinbergViolation");
            ++this.numHWViolations;
            isViolation = true;
        } else if (homVarProp > this.maxHomNonref) {
            filters.add("TooManyHomVars");
            ++this.numHomVarViolations;
            isViolation = true;
        }
        VariantContextBuilder builder = new VariantContextBuilder(vContext).filters(filters);
        ++this.numRecords;
        builder.attribute("NoCallPct", String.format("%.1f", 100.0 * noCallProp));
        builder.attribute("HomRefPct", String.format("%.1f", 100.0 * homRefProp));
        builder.attribute("HomVarPct", String.format("%.1f", 100.0 * homVarProp));
        builder.attribute("HetPct", String.format("%.1f", 100.0 * hetProp));
        builder.attribute("HW", String.format("%.2f", hwScore));
        List<Allele> altAlleles = vContext.getAlternateAlleles();
        int n = altAlleleCount = altAlleles.size() == 0 ? 0 : vContext.getCalledChrCount((Allele)altAlleles.iterator().next());
        if (!isViolation && altAlleleCount > 0) {
            ++this.numTrueVariants;
        }
        builder.attribute("AC", String.format("%d", altAlleleCount));
        builder.attribute("AN", String.format("%d", vContext.getCalledChrCount()));
        return builder.make();
    }

    private double hardyWeinbergCalculation(VariantContext vc) {
        return VariantContextUtils.computeHardyWeinbergPvalue(vc);
    }
}

